package com.github.tartaricacid.touhoulittlemaid.compat.jade.provider;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.*;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public enum AltarProvider implements IServerExtensionProvider<Object, class_1799>, IClientExtensionProvider<class_1799, ItemView> {

    INSTANCE;

    private static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "altar");

    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_1799>> list) {
        return ClientViewGroup.map(list, ItemView::new, null);
    }

    @Override
    public @Nullable List<ViewGroup<class_1799>> getGroups(class_3222 player, class_3218 world, Object target, boolean showDetails) {
        if (target instanceof TileEntityAltar altar) {
            class_1799 storageItem = altar.getStorageItem();
            if (!storageItem.method_7960()) {
                return List.of(new ViewGroup<>(Collections.singletonList(storageItem.method_7972())));
            }
        }
        return null;
    }

    @Override
    public class_2960 getUid() {
        return UID;
    }
}