package com.github.tartaricacid.touhoulittlemaid.compat.patchouli;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AltarRecipeComponent implements IComponentProcessor {
    private static final String RECIPE_ID = "recipe_id";
    private static final String INPUT = "input";
    private static final String POWER_COST = "power_cost";
    private static final String OUTPUT_ITEM = "output_item";
    private static final String OUTPUT_ENTITY = "output_entity";
    private static final String OUTPUT_DESC = "output_desc";

    private @Nullable AltarRecipe recipe;

    @Override
    public void setup(class_1937 level, IVariableProvider variables) {
        class_2960 recipeId = new class_2960(variables.get(RECIPE_ID).asString());
        List<AltarRecipe> allAltarRecipes = level.method_8433().method_30027(InitRecipes.ALTAR_CRAFTING);
        for (AltarRecipe recipe : allAltarRecipes) {
            if (recipe.method_8114().equals(recipeId)) {
                this.recipe = recipe;
                return;
            }
        }
        this.recipe = new AltarRecipe(new class_2960(TouhouLittleMaid.MOD_ID, "empty"),
                class_1299.field_6052, null, 0, class_1856.field_9017);
        TouhouLittleMaid.LOGGER.error("Altar recipe not found: {}", recipeId);
    }

    @Nullable
    @Override
    public IVariable process(class_1937 level, String key) {
        if (key.startsWith(INPUT)) {
            int index = Integer.parseInt(key.substring(INPUT.length())) - 1;
            if (index < 0 || index >= recipe.method_8117().size()) {
                return IVariable.from(class_1799.field_8037);
            }
            class_1856 ingredient = recipe.method_8117().get(index);
            class_1799[] stacks = ingredient.method_8105();
            if (stacks.length == 0) {
                return IVariable.from(class_1799.field_8037);
            }
            List<String> stackNames = Lists.newArrayList();
            for (class_1799 stack : stacks) {
                class_2960 itemId = class_7923.field_41178.method_10221(stack.method_7909());
                if (itemId != class_7923.field_41178.method_10137()) {
                    stackNames.add(itemId.toString());
                }
            }
            return IVariable.wrap(StringUtils.join(stackNames, ","));
        }

        switch (key) {
            case POWER_COST -> {
                float powerCost = recipe.getPowerCost();
                return IVariable.wrap(String.format("x%.2f", powerCost));
            }
            case OUTPUT_ITEM -> {
                return IVariable.from(recipe.method_8110(level.method_30349()));
            }
            case OUTPUT_DESC -> {
                String namespace = recipe.method_8114().method_12836().toLowerCase(Locale.US);
                String langKey;
                if (recipe.isItemCraft()) {
                    langKey = String.format("jei.%s.altar_craft.%s.result", namespace, "item_craft");
                } else {
                    Path path = Paths.get(recipe.method_8114().method_12832().toLowerCase(Locale.US));
                    langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
                }
                return IVariable.wrap(class_1074.method_4662(langKey));
            }
            case OUTPUT_ENTITY -> {
                class_1299<?> entityType = recipe.getEntityType();
                // 特判，女仆生成是实体对象是盒子，这里纠正为女仆
                if (entityType.equals(InitEntities.BOX)) {
                    entityType = InitEntities.MAID;
                }
                class_2960 entityId = class_7923.field_41177.method_10221(entityType);
                if (entityId != class_7923.field_41177.method_10137()) {
                    return IVariable.wrap(entityId.toString());
                } else {
                    return IVariable.wrap("minecraft:item");
                }
            }
        }

        return null;
    }
}