package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4215;

public class MaidExtinguishingTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speed;

    public MaidExtinguishingTask(float speed) {
        super(ImmutableMap.of());
        this.speed = speed;
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        return super.checkExtraStartConditions(worldIn, owner) && isExtinguisher(owner.method_6047());
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1937 world = maid.method_37908();
        class_1309 owner = maid.method_35057();
        class_1799 mainhandItem = maid.method_6047();
        class_4095<EntityMaid> brain = maid.method_18868();

        if (owner instanceof class_1657 && owner.method_5805() && owner.method_5809() && isExtinguisher(mainhandItem)
                && maid.method_18407(owner.method_24515())) {
            if (maid.method_24516(owner, 2)) {
                brain.method_18875(class_4140.field_18449);
                brain.method_18875(class_4140.field_18445);
                world.method_8649(new EntityExtinguishingAgent(worldIn, owner.method_19538()));
                mainhandItem.method_7956(1, maid, (m) -> m.method_20236(class_1268.field_5808));
                maid.method_6104(class_1268.field_5808);
            } else {
                class_4215.method_24557(maid, owner, speed, 2);
            }
        }

        if (maid.method_5809() && isExtinguisher(mainhandItem)) {
            world.method_8649(new EntityExtinguishingAgent(worldIn, maid.method_19538()));
            mainhandItem.method_7956(1, maid, (m) -> m.method_20236(class_1268.field_5808));
            maid.method_6104(class_1268.field_5808);
        }

        List<class_1321> tameableEntities = world.method_8390(class_1321.class, maid.method_5829().method_1009(2, 1, 2), class_1297::method_5809);
        if (!tameableEntities.isEmpty() && isExtinguisher(mainhandItem)) {
            world.method_8649(new EntityExtinguishingAgent(worldIn, maid.method_19538()));
            mainhandItem.method_7956(1, maid, (m) -> m.method_20236(class_1268.field_5808));
            maid.method_6104(class_1268.field_5808);
        }
    }

    private boolean isExtinguisher(class_1799 stack) {
        return stack.method_7909() == InitItems.EXTINGUISHER;
    }
}
