package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

import static net.minecraft.class_2248.method_20044;

public class MaidTorchMoveTask extends MaidMoveToBlockTask {
    private static final int LOW_BRIGHTNESS = 9;

    public MaidTorchMoveTask(float movementSpeed) {
        super(movementSpeed, 2);
    }

    @Override
    protected boolean shouldMoveTo(class_3218 worldIn, EntityMaid entityIn, class_2338 pos) {
        class_2338 posUp = pos.method_10084();
        if (worldIn.method_22339(posUp) < LOW_BRIGHTNESS && entityIn.canPlaceBlock(posUp)) {
            class_2680 stateUp = worldIn.method_8320(posUp);
            return method_20044(worldIn, pos, class_2350.field_11036) && !stateUp.method_51176();
        }
        return false;
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        if (!getTorchItem(maid).method_7960()) {
            searchForDestination(worldIn, maid);
        }
    }

    private class_1799 getTorchItem(EntityMaid entityMaid) {
        CombinedInvWrapper itemHandler = entityMaid.getAvailableInv(false);
        return ItemsUtil.getStack(itemHandler, stack -> stack.method_7909() == class_1802.field_8810);
    }
}
