package com.github.tartaricacid.touhoulittlemaid.entity.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5134;
import net.minecraft.class_7893;
import java.util.List;
import java.util.function.Predicate;

public class TaskBowAttack implements IRangedAttackTask {
    public static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "ranged_attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8102.method_7854();
    }

    @Nullable
    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(e -> hasBow(e) && hasArrow(e), IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138((target) -> !hasBow(maid) || !hasArrow(maid) || farAway(target, maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        class_7893<EntityMaid> maidAttackStrafingTask = new MaidAttackStrafingTask();
        class_7893<EntityMaid> shootTargetTask = new MaidShootTargetTask(2);

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, moveToTargetTask),
                Pair.of(5, maidAttackStrafingTask),
                Pair.of(5, shootTargetTask)
        );
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(e -> hasBow(e) && hasArrow(e), IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138((target) -> !hasBow(maid) || !hasArrow(maid) || farAway(target, maid));
        class_7893<EntityMaid> shootTargetTask = new MaidShootTargetTask(2);

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, shootTargetTask)
        );
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        class_1665 entityArrow = getArrow(shooter, distanceFactor);

        if (entityArrow != null) {
            class_1799 mainHandItem = shooter.method_6047();
            if (mainHandItem.method_7909() instanceof class_1753) {
                double x = target.method_23317() - shooter.method_23317();
                double y = target.method_23320() - shooter.method_23320();
                double z = target.method_23321() - shooter.method_23321();
                // 依据距离调整箭速和不准确度
                float distance = shooter.method_5739(target);
                float velocity = class_3532.method_15363(distance / 10f, 1.6f, 3.2f);
                float inaccuracy = 1 - class_3532.method_15363(distance / 100f, 0, 0.9f);
                // 射出的箭忽略重力，从而能让女仆百发百中
                entityArrow.method_5875(true);
                entityArrow.method_7485(x, y, z, velocity, inaccuracy);
                mainHandItem.method_7956(1, shooter, (maid) -> maid.method_20236(class_1268.field_5808));
                shooter.method_5783(class_3417.field_14633, 1.0F, 1.0F / (shooter.method_6051().method_43057() * 0.4F + 0.8F));
                shooter.field_6002.method_8649(entityArrow);
            }
        }
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.BOW_RANGE);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (hasBow(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014(searchRange);
            } else {
                return maid.method_5829().method_1014(searchRange);
            }
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return MaidConfig.BOW_RANGE.get();
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList(Pair.of("has_bow", this::hasBow), Pair.of("has_arrow", this::hasArrow));
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return stack.method_7909() instanceof class_1753;
    }

    private boolean hasBow(EntityMaid maid) {
        return maid.method_6047().method_7909() instanceof class_1753;
    }

    private boolean hasArrow(EntityMaid maid) {
        return findArrow(maid) >= 0;
    }

    private int findArrow(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        if (mainHandItem.method_7909() instanceof class_1753) {
            CombinedInvWrapper handler = maid.getAvailableInv(true);
            return ItemsUtil.findStackSlot(handler, ((class_1753) mainHandItem.method_7909()).method_19268());
        }
        return -1;
    }

    @Nullable
    private class_1665 getArrow(EntityMaid maid, float chargeTime) {
        int slot = findArrow(maid);
        if (slot < 0) {
            return null;
        }

        CombinedInvWrapper handler = maid.getAvailableInv(true);
        class_1799 arrowStack = handler.getStackInSlot(slot);
        class_1799 mainHandItem = maid.method_6047();
        class_1665 arrowEntity = class_1675.method_18813(maid, arrowStack, chargeTime);

        if (mainHandItem.method_7909() instanceof class_1753) {
            //arrowEntity = bowItem.customArrow(arrowEntity, arrowStack, mainHandItem);
        }
        // 无限附魔不存在或者小于 0 时
        if (class_1890.method_8225(class_1893.field_9125, mainHandItem) <= 0) {
            arrowStack.method_7934(1);
            handler.setStackInSlot(slot, arrowStack);
            // 记得把箭设置为可以拾起状态
            arrowEntity.field_7572 = class_1665.class_1666.field_7593;
        }

        // 箭伤害也和好感度挂钩
        class_1324 attackDamage = maid.method_5996(class_5134.field_23721);
        double attackValue = 2.0;
        if (attackDamage != null) {
            attackValue = attackDamage.method_6201();
        }
        float multiplier = (float) (attackValue / 2.0f);
        arrowEntity.method_7438(arrowEntity.method_7448() * multiplier);

        return arrowEntity;
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739(target) > this.searchRadius(maid);
    }
}