package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.block.BlockStatue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class ItemChisel extends class_1792 {
    public ItemChisel() {
        super((new class_1793()).method_7889(1).method_7895(64));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 worldIn = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();

        if (context.method_20287() == class_1268.field_5808 && player != null) {
            if (worldIn.method_8320(pos).method_26204() != class_2246.field_10460) {
                if (!worldIn.field_9236) {
                    player.method_43496(class_2561.method_43471("message.touhou_little_maid.chisel.hit_block_error"));
                }
                return class_1269.field_5811;
            }
            if (player.method_6079().method_7909() != InitItems.PHOTO) {
                if (!worldIn.field_9236) {
                    player.method_43496(class_2561.method_43471("message.touhou_little_maid.chisel.offhand_not_photo"));
                }
                return class_1269.field_5811;
            }
            genStatueBlocks(player, worldIn, pos, context.method_8038());
            if (player instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.CHISEL_STATUE);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private void genStatueBlocks(@Nonnull class_1657 player, @Nonnull class_1937 worldIn, @Nonnull class_2338 pos, @Nonnull class_2350 facing) {
        class_2487 data = ItemPhoto.getMaidData(player.method_6079());
        TileEntityStatue.Size[] sizes = TileEntityStatue.Size.values();
        for (int i = sizes.length - 1; i >= 0; i--) {
            TileEntityStatue.Size size = sizes[i];
            class_2382 dimension = size.getDimension();
            class_2338[] posList = checkBlocks(worldIn, pos, dimension, facing);
            if (posList != null) {
                boolean isTiny = false;
                if (posList.length == 1) {
                    isTiny = true;
                }
                for (class_2338 posIn : posList) {
                    worldIn.method_8652(posIn, InitBlocks.STATUE.method_9564().method_11657(BlockStatue.IS_TINY, isTiny), class_2248.field_31036);
                    class_2586 te = worldIn.method_8321(posIn);
                    if (te instanceof TileEntityStatue) {
                        TileEntityStatue statue = (TileEntityStatue) te;
                        if (posIn.equals(pos)) {
                            statue.setForgeData(size, true, pos, facing,
                                    Lists.newArrayList(posList), data);
                        } else {
                            statue.setForgeData(size, false, pos, facing,
                                    Lists.newArrayList(posList), null);
                        }
                    }
                }

                player.method_6047().method_7956(size.ordinal() + 1, player, (e) -> e.method_20236(class_1268.field_5808));
                player.method_5783(class_3417.field_14833, 0.5f, 1.5f);
                return;
            }
        }
    }


    @Nullable
    private class_2338[] checkBlocks(@Nonnull class_1937 worldIn, class_2338 origin, class_2382 dimension, class_2350 facing) {
        class_2338[] posList = new class_2338[dimension.method_10263() * dimension.method_10264() * dimension.method_10260()];
        int index = 0;
        for (int x = 0; x < dimension.method_10263(); x++) {
            for (int y = 0; y < dimension.method_10264(); y++) {
                for (int z = 0; z < dimension.method_10260(); z++) {
                    class_2338 pos = switch (facing) {
                        case field_11039 -> origin.method_10081(new class_2382(x, y, z));
                        case field_11035 -> origin.method_10081(new class_2382(x, y, -z));
                        default -> origin.method_10081(new class_2382(-x, y, z));
                        case field_11034 -> origin.method_10081(new class_2382(-x, y, -z));
                    };
                    posList[index] = pos;
                    index++;
                    if (worldIn.method_8320(pos).method_26204() != class_2246.field_10460) {
                        return null;
                    }
                }
            }
        }
        return posList;
    }
}
