package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.other.WirelessIOContainer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class ItemWirelessIO extends class_1792 implements ExtendedScreenHandlerFactory {
    private static final int FILTER_LIST_SIZE = 9;
    private static final String FILTER_LIST_TAG = "ItemFilterList";
    private static final String FILTER_MODE_TAG = "ItemFilterMode";
    private static final String IO_MODE_TAG = "ItemIOMode";
    private static final String BINDING_POS = "BindingPos";
    private static final String SLOT_CONFIG_TAG = "SlotConfigData";
    private static final String TOOLTIPS_PREFIX = "§a▍ §7";

    public ItemWirelessIO() {
        super((new class_1793()).method_7889(1));
    }

    public static void setMode(class_1799 stack, boolean maidToChest) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_7948().method_10556(IO_MODE_TAG, maidToChest);
        }
    }

    public static boolean isMaidToChest(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            if (stack.method_7985()) {
                class_2487 nbt = stack.method_7969();
                return Objects.requireNonNull(nbt).method_10577(IO_MODE_TAG);
            }
        }
        return false;
    }

    public static void setFilterMode(class_1799 stack, boolean isBlacklist) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_7948().method_10556(FILTER_MODE_TAG, isBlacklist);
        }
    }

    public static boolean isBlacklist(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            if (stack.method_7985()) {
                class_2487 nbt = stack.method_7969();
                return Objects.requireNonNull(nbt).method_10577(FILTER_MODE_TAG);
            }
        }
        return false;
    }

    public static ItemStackHandler getFilterList(class_1799 stack) {
        WirelessIOHandler handler = new WirelessIOHandler(FILTER_LIST_SIZE);
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            class_2487 tag = stack.method_7969();
            if (tag != null && tag.method_10573(FILTER_LIST_TAG, class_2520.field_33260)) {
                handler.deserializeNBT(tag.method_10562(FILTER_LIST_TAG));
            }
        }
        return handler;
    }

    public static void setFilterList(class_1799 stack, ItemStackHandler itemStackHandler) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_7948().method_10566(FILTER_LIST_TAG, itemStackHandler.serializeNBT());
        }
    }

    @Nullable
    public static class_2338 getBindingPos(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            class_2487 tag = stack.method_7969();
            if (tag != null && tag.method_10573(BINDING_POS, class_2520.field_33260)) {
                return class_2512.method_10691(tag.method_10562(BINDING_POS));
            }
        }
        return null;
    }

    public static void setBindingPos(class_1799 stack, class_2338 pos) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_7948().method_10566(BINDING_POS, class_2512.method_10692(pos));
        }
    }

    public static void setSlotConfig(class_1799 stack, byte[] config) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            stack.method_7948().method_10566(SLOT_CONFIG_TAG, new class_2479(config));
        }
    }

    @Nullable
    public static byte[] getSlotConfig(class_1799 stack) {
        if (stack.method_7909() == InitItems.WIRELESS_IO) {
            class_2487 tag = stack.method_7969();
            if (tag != null && tag.method_10573(SLOT_CONFIG_TAG, class_2520.field_33257)) {
                return tag.method_10547(SLOT_CONFIG_TAG);
            }
        }
        return null;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_1937 worldIn = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        class_2586 te = worldIn.method_8321(pos);

        if (hand != class_1268.field_5808) {
            return super.method_7884(context);
        }
        if (player == null) {
            return super.method_7884(context);
        }

        for (IChestType type : ChestManager.getAllChestTypes()) {
            if (!type.isChest(te)) {
                continue;
            }
            if (type.canOpenByPlayer(te, player)) {
                class_1799 stack = player.method_6047();
                setBindingPos(stack, pos);
                return class_1269.method_29236(worldIn.field_9236);
            }
        }
        return super.method_7884(context);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        if (handIn == class_1268.field_5808 && playerIn instanceof class_3222) {
            playerIn.method_17355(this);
            return class_1271.method_22427(playerIn.method_6047());
        }
        return super.method_7836(worldIn, playerIn, handIn);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        boolean maidToChest = isMaidToChest(stack);
        boolean isBlacklist = isBlacklist(stack);
        class_2338 pos = getBindingPos(stack);

        String ioModeText = maidToChest ?
                class_1074.method_4662("tooltips.touhou_little_maid.wireless_io.io_mode.input") :
                class_1074.method_4662("tooltips.touhou_little_maid.wireless_io.io_mode.output");
        String filterModeText = isBlacklist ?
                class_1074.method_4662("tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist") :
                class_1074.method_4662("tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist");
        String hasPos = (pos != null) ?
                class_1074.method_4662("tooltips.touhou_little_maid.wireless_io.binding_pos.has",
                        pos.method_10263(), pos.method_10264(), pos.method_10260()) :
                class_1074.method_4662("tooltips.touhou_little_maid.wireless_io.binding_pos.none");

        tooltip.add(class_2561.method_43470(TOOLTIPS_PREFIX + ioModeText));
        tooltip.add(class_2561.method_43470(TOOLTIPS_PREFIX + filterModeText));
        tooltip.add(class_2561.method_43470(TOOLTIPS_PREFIX + hasPos));
        tooltip.add(class_2561.method_43470(" "));
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.wireless_io.usage.1").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.wireless_io.usage.2").method_27692(class_124.field_1080));
    }

    @Override
    public class_2561 method_5476() {
        return class_2561.method_43471("item.touhou_little_maid.wireless_io");
    }

    @Nullable
    @Override
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new WirelessIOContainer(id, inventory, player.method_6047());
    }

    @Override
    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10793(player.method_6047());
    }


    private static class WirelessIOHandler extends ItemStackHandler {
        private WirelessIOHandler(int size) {
            super(size);
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}
