package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1282;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8103;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.HIGH;
import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.LOW;

public class NimbleFabricBauble implements IMaidBauble {
    private static final int MAX_RETRY = 16;

    public NimbleFabricBauble() {
        MaidAttackEvent.CALLBACK.addPhaseOrdering(HIGH, Event.DEFAULT_PHASE);
        MaidAttackEvent.CALLBACK.addPhaseOrdering(Event.DEFAULT_PHASE, LOW);
        MaidAttackEvent.CALLBACK.register(HIGH, this::onLivingDamage);
    }

    public void onLivingDamage(MaidAttackEvent event) {
        EntityMaid maid = event.getMaid();
        class_1282 source = event.getSource();
        if (source.method_48789(class_8103.field_42247)) {
            int slot = ItemsUtil.getBaubleSlotInMaid(maid, this);
            if (slot >= 0) {
                event.setCanceled(true);
                class_1799 stack = maid.getMaidBauble().getStackInSlot(slot);
                stack.method_7956(1, maid, m -> maid.sendItemBreakMessage(stack));
                maid.getMaidBauble().setStackInSlot(slot, stack);
                for (int i = 0; i < MAX_RETRY; ++i) {
                    if (TeleportHelper.teleport(maid)) {
                        if (maid.method_35057() instanceof class_3222 serverPlayer) {
                            InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_NIMBLE_FABRIC);
                        }
                        return;
                    }
                }
            }
        }
    }
}
