package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class ClearMaidAIDataMessage {
    private static final int ALL_MSG_INDEX = -1;
    public static final class_2960 ID = getResourceLocation("clear_maid_ai_data");


    public static class_2540 encode(int entityId) {
        return encode(entityId, ALL_MSG_INDEX);
    }

    public static class_2540 encode(int entityId, int msgIndex) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(entityId);
        buf.method_10804(msgIndex);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.method_10816();
        int msgIndex = buf.method_10816();
        server.execute(() -> handle(entityId, msgIndex, player));
    }

    private static void handle(int entityId, int msgIndex, @Nullable class_3222 player) {
        if (player == null) {
            return;
        }
        class_1297 entity = player.field_6002.method_8469(entityId);
        if (entity instanceof EntityMaid maid && maid.method_6171(player)) {
            if (msgIndex == ALL_MSG_INDEX) {
                maid.getAiChatManager().getHistory().getDeque().clear();
            }
        }
    }
}