package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class SetMaidSoundIdMessage {
    public static final class_2960 ID = getResourceLocation("set_maid_sound_id");

    public static class_2540 encode(int entityId, String soundId) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entityId);
        buf.method_10814(soundId);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int entityId = buf.readInt();
        String soundId = buf.method_19772();
        server.execute(() -> {
            class_1297 entity = sender.field_6002.method_8469(entityId);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                maid.setSoundPackId(soundId);
                InitTrigger.MAID_EVENT.trigger(sender, TriggerType.CHANGE_MAID_SOUND);
            }
        });
    }

}
