package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class WirelessIOGuiMessage {
    public static final class_2960 ID = getResourceLocation("wireless_io_gui");

    public static class_2540 encode(boolean isMaidToChest, boolean isBlacklist) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(isMaidToChest);
        buf.writeBoolean(isBlacklist);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        boolean isMaidToChest = buf.readBoolean();
        boolean isBlacklist = buf.readBoolean();
        server.execute(() -> {
            class_1799 handItem = sender.method_6047();
            if (handItem.method_7909() == InitItems.WIRELESS_IO) {
                ItemWirelessIO.setMode(handItem, isMaidToChest);
                ItemWirelessIO.setFilterMode(handItem, isBlacklist);
            }
        });
    }

}
