package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import java.util.List;

public class TileEntityStatue extends class_2586 implements IBlockEntityPersistentData {
    private static final String STATUE_SIZE_TAG = "StatueSize";
    public static final class_2591<TileEntityStatue> TYPE = class_2591.class_2592.method_20528(TileEntityStatue::new, InitBlocks.STATUE).method_11034(null);
    private static final String CORE_BLOCK_TAG = "CoreBlock";
    private static final String CORE_BLOCK_POS_TAG = "CoreBlockPos";
    private static final String STATUE_FACING_TAG = "StatueFacing";
    private static final String ALL_BLOCKS_TAG = "AllBlocks";
    private static final String EXTRA_MAID_DATA = "ExtraMaidData";
    private Size size = Size.SMALL;
    private boolean isCoreBlock = false;
    private class_2338 coreBlockPos = class_2338.field_10980;
    private class_2350 facing = class_2350.field_11043;
    private List<class_2338> allBlocks = Lists.newArrayList();
    @Nullable
    private class_2487 extraMaidData = null;

    public TileEntityStatue(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void setForgeData(Size size, boolean isCoreBlock, class_2338 coreBlockPos, class_2350 facing,
                             List<class_2338> allBlocks, @Nullable class_2487 extraData) {
        this.size = size;
        this.isCoreBlock = isCoreBlock;
        this.coreBlockPos = coreBlockPos;
        this.facing = facing;
        this.allBlocks = allBlocks;
        this.extraMaidData = extraData;
        refresh();
    }

    @Override
    public void method_11007(class_2487 compound) {
        tlm$getPersistentData().method_10569(STATUE_SIZE_TAG, size.ordinal());
        tlm$getPersistentData().method_10556(CORE_BLOCK_TAG, isCoreBlock);
        tlm$getPersistentData().method_10566(CORE_BLOCK_POS_TAG, class_2512.method_10692(coreBlockPos));
        tlm$getPersistentData().method_10582(STATUE_FACING_TAG, facing.method_15434());
        class_2499 blockList = new class_2499();
        for (class_2338 pos : allBlocks) {
            blockList.add(class_2512.method_10692(pos));
        }
        tlm$getPersistentData().method_10566(ALL_BLOCKS_TAG, blockList);
        if (extraMaidData != null) {
            tlm$getPersistentData().method_10566(EXTRA_MAID_DATA, extraMaidData);
        }
        super.method_11007(compound);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        size = Size.getSizeByIndex(tlm$getPersistentData().method_10550(STATUE_SIZE_TAG));
        isCoreBlock = tlm$getPersistentData().method_10577(CORE_BLOCK_TAG);
        coreBlockPos = class_2512.method_10691(tlm$getPersistentData().method_10562(CORE_BLOCK_POS_TAG));
        facing = class_2350.method_10168(tlm$getPersistentData().method_10558(STATUE_FACING_TAG));
        allBlocks.clear();
        class_2499 blockList = tlm$getPersistentData().method_10554(ALL_BLOCKS_TAG, class_2520.field_33260);
        for (int i = 0; i < blockList.size(); i++) {
            allBlocks.add(class_2512.method_10691(blockList.method_10602(i)));
        }
        if (tlm$getPersistentData().method_10573(EXTRA_MAID_DATA, class_2520.field_33260)) {
            extraMaidData = tlm$getPersistentData().method_10562(EXTRA_MAID_DATA);
        }
    }

//    @Override
//    @Environment(EnvType.CLIENT)
//    public AABB getRenderBoundingBox() {
//        return new AABB(worldPosition.offset(-5, -1, -5), worldPosition.offset(5, 10, 5));
//    }

    @Override
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    public void refresh() {
        this.method_5431();
        if (field_11863 != null) {
            class_2680 state = field_11863.method_8320(field_11867);
            field_11863.method_8413(field_11867, state, state, class_2248.field_31036);
        }
    }

    public Size getSize() {
        return size;
    }

    public boolean isCoreBlock() {
        return isCoreBlock;
    }

    public class_2338 getCoreBlockPos() {
        return coreBlockPos;
    }

    public class_2350 getFacing() {
        return facing;
    }

    public List<class_2338> getAllBlocks() {
        return allBlocks;
    }

    @Nullable
    public class_2487 getExtraMaidData() {
        return extraMaidData;
    }

    public enum Size {
        // 雕像的尺寸
        TINY(0.5f, new class_2382(1, 1, 1)),
        SMALL(1.0f, new class_2382(1, 2, 1)),
        MIDDLE(2.0f, new class_2382(2, 4, 2)),
        BIG(3.0f, new class_2382(3, 6, 3));

        private final float scale;
        private final class_2382 dimension;

        Size(float scale, class_2382 dimension) {
            this.scale = scale;
            this.dimension = dimension;
        }

        public static Size getSizeByIndex(int index) {
            return Size.values()[class_3532.method_15340(index, 0, Size.values().length - 1)];
        }

        public float getScale() {
            return scale;
        }

        public class_2382 getDimension() {
            return dimension;
        }
    }


}
