package cn.sh1rocu.touhoulittlemaid.mixin.client;

import cn.sh1rocu.touhoulittlemaid.api.event.AddPackFindersEvent;
import cn.sh1rocu.touhoulittlemaid.api.event.RegisterClientReloadListenersEvent;
import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.api.extension.IPickedResult;
import cn.sh1rocu.touhoulittlemaid.api.mixin.PackRepositoryExtension;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3304;
import net.minecraft.class_542;
import net.minecraft.class_638;
import net.minecraft.class_702;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_310.class)
public abstract class MinecraftMixin {
    @Shadow
    @Nullable
    public class_638 level;

    @Shadow
    @Nullable
    public class_239 hitResult;

    @Shadow
    public abstract class_3283 getResourcePackRepository();

    @Shadow
    @Final
    private class_3304 resourceManager;

    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/Window;updateVsync(Z)V"))
    private void sbm$onInit(CallbackInfo ci) {
        RegisterClientReloadListenersEvent.CALLBACK.invoker().post(new RegisterClientReloadListenersEvent(this.resourceManager));
    }

    @WrapWithCondition(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/particle/ParticleEngine;crack(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V"
            )
    )
    private boolean tlm$addHitEffects(class_702 engine, class_2338 pos, class_2350 side) {
        class_2680 state = this.level.method_8320(pos);
        if (state.method_26204() instanceof IBlock block)
            return !block.addHitEffects(state, level, this.hitResult, engine);
        return true;
    }

    @ModifyExpressionValue(
            method = "pickBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;getPickResult()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 tlm$pickBlock(class_1799 stack) {
        if (stack != null && stack.method_7909() instanceof IPickedResult item)
            return item.getPickedResult(this.hitResult);
        return stack;
    }

    @Inject(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/packs/repository/PackRepository;reload()V"))
    private void tlm$addPacks(class_542 gameConfig, CallbackInfo ci) {
        AddPackFindersEvent event = new AddPackFindersEvent(class_3264.field_14188, ((PackRepositoryExtension) this.getResourcePackRepository())::tlm$addPackFinder, false);
        AddPackFindersEvent.CALLBACK.invoker().onAddPackFinders(event);
    }
}