package cn.sh1rocu.touhoulittlemaid.util.forge.network;

import net.minecraft.class_9129;

/**
 * An interface for Entities that need extra information to be communicated
 * between the server and client when they are spawned.
 */
public interface IEntityWithComplexSpawn {
    /**
     * Called by the server when constructing the spawn packet.
     * Data should be added to the provided stream.
     *
     * @param buffer The packet data stream
     */
    void writeSpawnData(class_9129 buffer);

    /**
     * Called by the client when it receives a Entity spawn packet.
     * Data should be read out of the stream in the same way as it was written.
     *
     * @param additionalData The packet data stream
     */
    void readSpawnData(class_9129 additionalData);
}
