package com.github.tartaricacid.touhoulittlemaid.client.event;


import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemKappaCompass;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4168;
import net.minecraft.class_4588;

@Environment(EnvType.CLIENT)
public class CompassRenderEvent {
    //after block entities
    public static void onRender(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_1799 stack = mc.field_1724.method_6047();
        if (stack.method_7909() != InitItems.KAPPA_COMPASS) {
            stack = mc.field_1724.method_6079();
            if (stack.method_7909() != InitItems.KAPPA_COMPASS) {
                return;
            }
        }
        if (!ItemKappaCompass.hasKappaCompassData(stack)) {
            return;
        }
        class_2960 dimension = ItemKappaCompass.getDimension(stack);
        if (dimension != null && !mc.field_1724.field_6002.method_27983().method_29177().equals(dimension)) {
            return;
        }
        class_2338 workPos = ItemKappaCompass.getPoint(class_4168.field_18596, stack);
        class_243 camera = context.camera().method_19326().method_22882();
        context.matrixStack().method_22903();
        context.matrixStack().method_46416(0, 1, 0);
        if (workPos != null) {
            class_243 centerPos = camera.method_1031(workPos.method_10263() + 0.5, workPos.method_10264() + 0.5, workPos.method_10260() + 0.5);
            double radius = MaidConfig.MAID_WORK_RANGE.get() + 0.1;
            class_4588 buffer = mc.method_22940().method_23000().getBuffer(class_1921.field_21695);
            RenderHelper.renderCylinder(context.matrixStack(), buffer, centerPos, radius, 16, 1.0F, 0, 0);
            class_243 textPos = new class_243(workPos.method_10263() + 0.5, workPos.method_10264() + 2, workPos.method_10260() + 0.5);
            String text = class_1074.method_4662("message.touhou_little_maid.kappa_compass.work_area");
            RenderHelper.renderFloatingText(context.matrixStack(), text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0xff1111, 0.15f, true, -5, false);
            RenderHelper.renderFloatingText(context.matrixStack(), "▼", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0xff1111, 0.15f, true, 5, false);
        }

        class_2338 idlePos = ItemKappaCompass.getPoint(class_4168.field_18595, stack);
        if (idlePos != null) {
            class_243 centerPos = camera.method_1031(idlePos.method_10263() + 0.5, idlePos.method_10264() + 0.5, idlePos.method_10260() + 0.5);
            double radius = MaidConfig.MAID_IDLE_RANGE.get();
            class_4588 buffer = mc.method_22940().method_23000().getBuffer(class_1921.field_21695);
            RenderHelper.renderCylinder(context.matrixStack(), buffer, centerPos, radius, 16, 0, 1.0F, 0);
            class_243 textPos = new class_243(idlePos.method_10263() + 0.5, idlePos.method_10264() + 2, idlePos.method_10260() + 0.5);
            if (idlePos.equals(workPos)) {
                textPos = textPos.method_1031(0, 1, 0);
            } else if (workPos != null) {
                class_243 prePos = camera.method_1031(workPos.method_10263() + 0.5, workPos.method_10264() + 0.5, workPos.method_10260() + 0.5);
                RenderHelper.renderLine(context.matrixStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            String text = class_1074.method_4662("message.touhou_little_maid.kappa_compass.idle_area");
            RenderHelper.renderFloatingText(context.matrixStack(), text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x11ff11, 0.15f, true, -5, false);
            RenderHelper.renderFloatingText(context.matrixStack(), "▼", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x11ff11, 0.15f, true, 5, false);
        }

        class_2338 resetPos = ItemKappaCompass.getPoint(class_4168.field_18597, stack);
        if (resetPos != null) {
            class_243 centerPos = camera.method_1031(resetPos.method_10263() + 0.5, resetPos.method_10264() + 0.5, resetPos.method_10260() + 0.5);
            double radius = MaidConfig.MAID_SLEEP_RANGE.get() - 0.1;
            class_4588 buffer = mc.method_22940().method_23000().getBuffer(class_1921.field_21695);
            RenderHelper.renderCylinder(context.matrixStack(), buffer, centerPos, radius, 16, 0, 0, 1.0F);
            class_243 textPos = new class_243(resetPos.method_10263() + 0.5, resetPos.method_10264() + 2, resetPos.method_10260() + 0.5);
            if (resetPos.equals(idlePos)) {
                textPos = textPos.method_1031(0, 2, 0);
            } else if (idlePos != null && workPos != null) {
                class_243 prePos = camera.method_1031(idlePos.method_10263() + 0.5, idlePos.method_10264() + 0.5, idlePos.method_10260() + 0.5);
                RenderHelper.renderLine(context.matrixStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                prePos = camera.method_1031(workPos.method_10263() + 0.5, workPos.method_10264() + 0.5, workPos.method_10260() + 0.5);
                RenderHelper.renderLine(context.matrixStack(), buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            String text = class_1074.method_4662("message.touhou_little_maid.kappa_compass.sleep_area");
            RenderHelper.renderFloatingText(context.matrixStack(), text, textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x1111ff, 0.15f, true, -5, false);
            RenderHelper.renderFloatingText(context.matrixStack(), "▼", textPos.field_1352, textPos.field_1351, textPos.field_1350, 0x1111ff, 0.15f, true, 5, false);
        }
        context.matrixStack().method_22909();
    }
}
