package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.Collection;

public final class PowerCommand {
    private static final String POWER_NAME = "power";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> pack = class_2170.method_9247(POWER_NAME);
        RequiredArgumentBuilder<class_2168, class_2300> targets = class_2170.method_9244(TARGETS_NAME, class_2186.method_9308());
        RequiredArgumentBuilder<class_2168, Float> count = class_2170.method_9244(COUNT_NAME, FloatArgumentType.floatArg(0, PowerAttachment.MAX_POWER));
        RequiredArgumentBuilder<class_2168, String> handleType = class_2170.method_9244(HANDLE_NAME, HandleTypeArgument.type());

        pack.then(class_2170.method_9247(GET_NAME).then(targets.executes(PowerCommand::getPower)));
        pack.then(handleType.then(targets.then(count.executes(PowerCommand::handlePower))));
        return pack;
    }

    private static int handlePower(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection<class_3222> players = class_2186.method_9312(context, TARGETS_NAME);
        float count = FloatArgumentType.getFloat(context, COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        for (class_3222 player : players) {
            PowerAttachment powerAttachment = player.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0));
            MaidNumAttachment maidNumAttachment = player.getAttachedOrCreate(InitDataAttachment.MAID_NUM, () -> new MaidNumAttachment(0));
            switch (type) {
                case "set":
                    powerAttachment.set(count);
                    break;
                case "add":
                    powerAttachment.add(count);
                    break;
                case "min":
                    powerAttachment.min(count);
                    break;
                default:
            }
            player.setAttached(InitDataAttachment.POWER_NUM, new PowerAttachment(powerAttachment.get()));
            ServerPlayNetworking.send(player, new SyncDataPackage(powerAttachment.get(), maidNumAttachment.get()));
        }
        context.getSource().method_9226(() -> class_2561.method_43469("commands.touhou_little_maid.power.handle.info", players.size()), true);
        return Command.SINGLE_SUCCESS;
    }

    private static int getPower(CommandContext<class_2168> context) throws CommandSyntaxException {
        for (class_1657 player : class_2186.method_9312(context, TARGETS_NAME)) {
            PowerAttachment power = player.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0));
            context.getSource().method_9226(() -> class_2561.method_43469("commands.touhou_little_maid.power.get.info",
                    player.method_5820(), power.get()), false);
        }
        return Command.SINGLE_SUCCESS;
    }
}
