package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.TagItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9274;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public class EnchantmentKeys {
    public static final class_5321<class_1887> IMPEDING = registerKey("impeding");
    public static final class_5321<class_1887> SPEEDY = registerKey("speedy");
    public static final class_5321<class_1887> ENDERS_ENDER = registerKey("enders_ender");

    private static class_5321<class_1887> registerKey(String name) {
        return class_5321.method_29179(class_7924.field_41265, getResourceLocation(name));
    }

    public static void bootstrap(class_7891<class_1887> context) {
        class_7871<class_8110> damageTypes = context.method_46799(class_7924.field_42534);
        class_7871<class_1887> enchantments = context.method_46799(class_7924.field_41265);
        class_7871<class_1792> items = context.method_46799(class_7924.field_41197);
        class_7871<class_2248> blocks = context.method_46799(class_7924.field_41254);

        // TODO 附魔的参数可能会需要调
        register(context, IMPEDING, new class_1887.class_9700(
                class_1887.method_58442(
                        items.method_46735(TagItem.GOHEI_ENCHANTABLE),
                        4,
                        4,
                        class_1887.method_58441(10, 8),
                        class_1887.method_58441(15, 8),
                        1,
                        class_9274.field_49217
                )
        ));

        register(context, SPEEDY, new class_1887.class_9700(
                class_1887.method_58442(
                        items.method_46735(TagItem.GOHEI_ENCHANTABLE),
                        2,
                        2,
                        class_1887.method_58441(15, 10),
                        class_1887.method_58441(20, 10),
                        2,
                        class_9274.field_49217
                )
        ));

        register(context, ENDERS_ENDER, new class_1887.class_9700(
                class_1887.method_58442(
                        items.method_46735(TagItem.GOHEI_ENCHANTABLE),
                        1,
                        1,
                        class_1887.method_58440(20),
                        class_1887.method_58440(50),
                        4,
                        class_9274.field_49217
                )
        ));
    }

    private static void register(class_7891<class_1887> context, class_5321<class_1887> key, class_1887.class_9700 builder) {
        context.method_46838(key, builder.method_60060(key.method_29177()));
    }

    public static int getEnchantmentLevel(class_5455 access, class_5321<class_1887> enchantmentResourceKey, class_1799 mainHandItem) {
        return class_1890.method_8225(getEnchantmentHolder(access, enchantmentResourceKey), mainHandItem);
    }

    public static class_6880<class_1887> getEnchantmentHolder(class_5455 access, class_5321<class_1887> enchantmentResourceKey) {
        return access.method_30530(class_7924.field_41265).method_40290(enchantmentResourceKey);
    }
}
