package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.forge.CommonHooks;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_11;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_9;

public class MaidClimbTask extends class_4097<EntityMaid> {
    public MaidClimbTask() {
        super(ImmutableMap.of());
    }

    @Override
    protected void start(class_3218 pLevel, EntityMaid maid, long pGameTime) {
        // 初始化女仆动量
        // 将女仆定格在楼梯中心，取消掉 x、z 轴的动量，避免爬楼梯过程中摔死
        class_2338 currentPosition = maid.method_24515().method_25503();
        class_243 centerPos = class_243.method_24953(currentPosition);
        maid.method_24203(centerPos.field_1352, currentPosition.method_10264(), centerPos.field_1350);
        maid.method_18800(0, maid.method_18798().method_10214(), 0);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 pLevel, EntityMaid maid) {
        // 如果禁用了主动攀爬能力，就直接返回，不执行后续的操作
        if (!maid.getConfigManager().isActiveClimbing()) {
            return false;
        }
        return maid.method_6101();
    }

    @Override
    protected boolean canStillUse(class_3218 pLevel, EntityMaid pEntity, long pGameTime) {
        return this.checkExtraStartConditions(pLevel, pEntity);
    }

    @Override
    protected void tick(class_3218 level, EntityMaid maid, long pGameTime) {
        class_11 path = maid.method_5942().method_6345();
        if (path == null || path.method_46()) {
            maid.setCanClimb(false);
            return;
        }

        maid.setCanClimb(true);
        // 获取基础信息：下一个要到达的节点、女仆当前所处坐标、方块
        int beGoNodeIndex = path.method_39();
        class_9 beGoNode = path.method_40(beGoNodeIndex);
        class_2338 maidFeetPos = maid.method_24515();
        class_2680 feetBlock = level.method_8320(maidFeetPos);

        // 判断上行还是下行
        boolean up = true;
        if (beGoNodeIndex > 0) {
            class_9 currentNext = path.method_40(beGoNodeIndex - 1);
            class_9 pointNext = path.method_40(beGoNodeIndex);
            if (pointNext.field_39 <= currentNext.field_39) {
                up = false;
            }
        }

        // 如果是下行，添加 shift 行为
        maid.method_5660(!up);

        // 控制上行和下行楼梯的动量
        // 将水平方向的动量关掉，与上面的初始化，定格在方块中心，不然会摔死……
        // 先给一个大点的 y 轴向量，再拉回一点，这样能连续下去
        // 原版的爬楼梯数值为 0.15，有些慢，加快点……
        // 而且速度太慢的话，爬楼梯时间过长，路径就被掐断了，
        // 就又会重新规划路线……这样控制比较麻烦，而且也还有其他的东西在干扰……
        // 最好的是一次路径控制完，这样的效果是最好的
        if (maidFeetPos.method_10264() <= beGoNode.field_39 && up && CommonHooks.isLadder(feetBlock, level, maidFeetPos, maid) /*feetBlock.isLadder(level, maidFeetPos, maid)*/) {
            double yMotion0 = 1;
            double yMotion = 0.25;
            maid.method_18800(0, yMotion0, 0);
            maid.method_18800(0, yMotion, 0);
        } else {
            double yMotion0 = -1;
            double yMotion = -0.25;
            maid.method_18800(0, yMotion0, 0);
            maid.method_18800(0, yMotion, 0);
        }

        // 对下行做出额外处理
        // 下行的最近节点索引值很奇怪……
        // 女仆都还没到那个下一个节点附近，就启动切换到下一个节点了……
        // 上行的就没有这个问题……
        if (!up && beGoNode.field_39 != maidFeetPos.method_10264()) {
            int nodeCount = path.method_38();
            for (int i1 = 0; i1 < nodeCount; i1++) {
                class_9 node = path.method_40(i1);
                class_9 nextNode = path.method_40(Math.min(i1 + 1, nodeCount - 1));
                // 获取正确的节点信息
                if (node.field_39 == maidFeetPos.method_10264() && node.field_40 == maidFeetPos.method_10263() && node.field_38 == maidFeetPos.method_10260() && node.field_39 == nextNode.field_39) {
                    beGoNodeIndex = i1;
                    beGoNode = node;
                    // 更正最近索引点
                    path.method_42(i1);
                    break;
                }
            }
        }
        // 控制正常情况下到达该段楼梯节点顶部或者底部向着平台进发
        if ((beGoNode.field_39 - maidFeetPos.method_10264() >= 0 && beGoNode.field_39 - maidFeetPos.method_10264() <= 1.2) && beGoNodeIndex + 1 < path.method_38()) {
            class_9 currentNext = path.method_40(beGoNodeIndex);
            class_9 pointNext = path.method_40(beGoNodeIndex + 1);

            boolean beWalkSurface = pointNext.field_39 == currentNext.field_39;
            if (beWalkSurface || pointNext == path.method_45() || maidFeetPos.method_10264() == currentNext.field_39) {
                maid.setCanClimb(false);
                // 给予女仆当前坐标与水平节点的x、z方向的差值向量，
                // 让其向着那个水平节点进发，脱离楼梯等可爬行物体，不再继续爬楼梯或者停留在上面
                int x1 = pointNext.field_40 - currentNext.field_40;
                int z1 = pointNext.field_38 - currentNext.field_38;
                double y = maid.method_18798().method_10214();
                maid.method_18800(0.2, 1, 0.2);
                maid.method_18800(x1 * 0.3, y + 0.012, z1 * 0.3);
                // TODO：将身体转向下一个节点
                maid.method_18868().method_18878(class_4140.field_18446, new class_4099(pointNext.method_35496()));
            }
        }
    }

    @Override
    protected void stop(class_3218 pLevel, EntityMaid maid, long pGameTime) {
        maid.method_5660(false);
        maid.setCanClimb(false);
    }
}
