package com.github.tartaricacid.touhoulittlemaid.entity.task.crop;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2421;
import net.minecraft.class_2680;
import net.minecraft.class_5712;
import net.minecraft.class_6088;

public class NetherWartCropHandler implements ISpecialCropHandler {
    @Override
    public boolean canHarvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        return cropState.method_11654(class_2421.field_11306) >= class_2421.field_31199;
    }

    @Override
    public void harvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState, boolean isDestroyMode) {
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else {
            CombinedInvWrapper availableInv = maid.getAvailableInv(false);

            class_1799 dropItemStack = new class_1799(class_1802.field_8790);
            class_1799 remindItemStack = ItemHandlerHelper.insertItemStacked(availableInv, dropItemStack, false);
            if (!remindItemStack.method_7960()) {
                class_2248.method_9577(maid.field_6002, cropPos, remindItemStack);
            }
            maid.field_6002.method_20290(class_6088.field_31144, cropPos, class_2248.method_9507(cropState));
            maid.field_6002.method_8652(cropPos, class_2246.field_9974.method_9564(), class_2248.field_31036);
            maid.field_6002.method_33596(maid, class_5712.field_28733, cropPos);
        }
    }
}