package com.github.tartaricacid.touhoulittlemaid.network.message;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_490;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

/**
 * 与扫帚骑乘有关的消息，从服务端到客户端
 */
public record OpenPlayerInventoryPackage(int action) implements class_8710 {
    public static final int OPEN_PLAYER_INVENTORY = 0;
    public static final class_8710.class_9154<OpenPlayerInventoryPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("open_player_inventory"));
    public static final class_9139<class_9129, OpenPlayerInventoryPackage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48550, OpenPlayerInventoryPackage::action,
            OpenPlayerInventoryPackage::new
    );

    public static void handle(OpenPlayerInventoryPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> onHandle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(OpenPlayerInventoryPackage message) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (message.action == OPEN_PLAYER_INVENTORY) {
            // 打开玩家背包
            class_310.method_1551().method_1507(new class_490(player));
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}