package cn.sh1rocu.touhoulittlemaid.mixin.common;

import cn.sh1rocu.touhoulittlemaid.util.forge.EventHooks;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_9109;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

// Porting Lib
@Mixin(class_1665.class)
public abstract class AbstractArrowMixin extends class_1297 {
    public AbstractArrowMixin(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    @WrapOperation(method = "tick", at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;hitTargetOrDeflectSelf(Lnet/minecraft/world/phys/HitResult;)Lnet/minecraft/world/entity/projectile/ProjectileDeflection;"
    ))
    private class_9109 tlm$onProjectileImpact(class_1665 instance, class_239 hitResult, Operation<class_9109> original, @Share("canceled") LocalBooleanRef canceled, @Share("hasImpulse") LocalBooleanRef lastHasImpulse) {
        if (EventHooks.onProjectileImpact(instance, hitResult)) {
            canceled.set(true);
            lastHasImpulse.set(this.field_6007);
            return class_9109.field_48348; // Return anything that isn't none
        }
        canceled.set(false);
        return original.call(instance, hitResult);
    }

    @Inject(method = "tick", at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;hasImpulse:Z", shift = At.Shift.AFTER))
    private void tlm$restoreHasImpulse(CallbackInfo ci, @Share("canceled") LocalBooleanRef canceled, @Share("hasImpulse") LocalBooleanRef lastHasImpulse) {
        if (canceled.get())
            this.field_6007 = lastHasImpulse.get();
    }
}