package cn.sh1rocu.touhoulittlemaid.mixin.common;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2596;
import net.minecraft.class_8038;

/**
 * this is needed for {@link cn.sh1rocu.touhoulittlemaid.util.forge.network.IEntityWithComplexSpawn} to work properly on dedicated servers, since it ends up nesting bundle packets.
 */

// PortingLib
@Mixin(class_8038.class)
public class BundlePacketMixin {
    @ModifyVariable(method = "<init>", at = @At("HEAD"), argsOnly = true)
    private static Iterable<class_2596<?>> tlm$flattenPackets(Iterable<class_2596<?>> packets) {
        List<class_2596<?>> list = new ArrayList<>();
        tlm$recursivelyCollectBundledPackets(packets, list);
        return list;
    }

    @Unique
    private static void tlm$recursivelyCollectBundledPackets(Iterable<class_2596<?>> packets, List<class_2596<?>> list) {
        for (class_2596<?> packet : packets) {
            if (packet instanceof class_8038<?> bundle) {
                //noinspection unchecked,rawtypes
                tlm$recursivelyCollectBundledPackets((Iterable) bundle.method_48324(), list);
            } else {
                list.add(packet);
            }
        }
    }
}