package cn.sh1rocu.touhoulittlemaid.mixin.common;

import cn.sh1rocu.touhoulittlemaid.api.event.LivingAttackEvent;
import cn.sh1rocu.touhoulittlemaid.api.extension.IBedBlock;
import cn.sh1rocu.touhoulittlemaid.util.forge.EventHooks;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract Optional<class_2338> getSleepingPos();

    @Shadow
    public abstract class_1799 getUseItem();

    @Shadow
    public abstract int getUseItemRemainingTicks();

    @Shadow
    protected int lastHurtByPlayerTime;

    @Shadow
    @Nullable
    protected class_1657 lastHurtByPlayer;

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(
            method = "startSleeping",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;setPose(Lnet/minecraft/world/entity/Pose;)V"
            )
    )
    private void tlm$startSleeping(class_2338 pos, CallbackInfo ci, @Local class_2680 state) {
        if (!(state.method_26204() instanceof class_2244) && state.method_26204() instanceof IBedBlock bedBlock) {
            if (bedBlock.tlm$isBed(state, this.method_37908(), pos, (class_1309) (Object) this))
                this.method_37908().method_8652(pos, state.method_11657(class_2244.field_9968, true), 3);
        }
    }

    @Inject(
            method = "checkBedExists",
            at = @At("HEAD"),
            cancellable = true
    )
    private void tlm$checkBedExists(CallbackInfoReturnable<Boolean> cir) {
        Optional<class_2338> blockPos = this.getSleepingPos();
        if (blockPos.isPresent()) {
            class_2680 state = this.method_37908().method_8320(blockPos.get());
            if (state.method_26204() instanceof IBedBlock bedBlock)
                cir.setReturnValue(bedBlock.tlm$isBed(state, this.method_37908(), blockPos.get(), (class_1309) (Object) this));
            else cir.setReturnValue(state.method_26204() instanceof class_2244);
        }
    }

    @Inject(
            method = "stopSleeping",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;position()Lnet/minecraft/world/phys/Vec3;"
            )
    )
    private void tlm$stopSleeping(CallbackInfo ci) {
        Optional<class_2338> sleepingPos = this.getSleepingPos();
        sleepingPos.filter(this.method_37908()::method_22340).ifPresent((blockPos) -> {
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            if (!(blockState.method_26204() instanceof class_2244) && blockState.method_26204() instanceof IBedBlock bedBlock) {
                if (bedBlock.tlm$isBed(blockState, this.method_37908(), blockPos, (class_1309) (Object) this)) {
                    class_2350 direction = blockState.method_11654(class_2244.field_11177);
                    this.method_37908().method_8652(blockPos, blockState.method_11657(class_2244.field_9968, false), 3);
                    class_243 vec3 = class_2244.method_9484(this.method_5864(), this.method_37908(), blockPos, direction, this.method_36454()).orElseGet(() -> {
                        class_2338 blockPos2 = blockPos.method_10084();
                        return new class_243((double) blockPos2.method_10263() + (double) 0.5F, (double) blockPos2.method_10264() + 0.1, (double) blockPos2.method_10260() + (double) 0.5F);
                    });
                    class_243 vec32 = class_243.method_24955(blockPos).method_1020(vec3).method_1029();
                    float f = (float) class_3532.method_15338(class_3532.method_15349(vec32.field_1350, vec32.field_1352) * (double) (180F / (float) Math.PI) - (double) 90.0F);
                    this.method_5814(vec3.field_1352, vec3.field_1351, vec3.field_1350);
                    this.method_36456(f);
                    this.method_36457(0.0F);
                }
            }
        });
    }

    @Inject(
            method = "getBedOrientation",
            at = @At("HEAD"),
            cancellable = true
    )
    private void tlm$getBedOrientation(CallbackInfoReturnable<class_2350> cir) {
        class_2338 blockPos = this.getSleepingPos().orElse(null);
        if (blockPos == null) return;
        class_2680 state = this.method_37908().method_8320(blockPos);
        if (state.method_26204() instanceof IBedBlock bedBlock)
            cir.setReturnValue(!bedBlock.tlm$isBed(state, this.method_37908(), blockPos, (class_1309) (Object) this) ? class_2350.field_11036 : state.method_11654(class_2383.field_11177));
    }

    @WrapOperation(method = "completeUsingItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"))
    public class_1799 tlm$onItemUseFinish(class_1799 instance, class_1937 level, class_1309 livingEntity, Operation<class_1799> original) {
        return EventHooks.onItemUseFinish((class_1309) (Object) this, this.getUseItem().method_7972(), this.getUseItemRemainingTicks(), original.call(instance, level, livingEntity));
    }

    // 女仆攻击完成后，给受伤实体设置lastHurtByPlayerTime，便于经验掉落等计算
    @Inject(
            method = "hurt",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/damagesource/DamageSource;getEntity()Lnet/minecraft/world/entity/Entity;")
    )
    private void tlm$hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof EntityMaid maid && maid.method_6181()) {
            this.lastHurtByPlayerTime = 100;
            if (maid.method_35057() instanceof class_1657 player) {
                this.lastHurtByPlayer = player;
            } else {
                this.lastHurtByPlayer = null;
            }
        }
    }

    @Inject(method = "hurt", at = @At("HEAD"), cancellable = true)
    public void tlm$attackEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309) (Object) this;
        if (!(self instanceof class_1657)) {
            LivingAttackEvent event = new LivingAttackEvent(self, source, amount);
            LivingAttackEvent.CALLBACK.invoker().onLivingAttack(event);
            if (event.isCanceled())
                cir.setReturnValue(false);
        }
    }
}
