package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ItemHandlerHelper {
    public static class_1799 insertItem(IItemHandler dest, class_1799 stack, boolean simulate) {
        if (dest == null || stack.method_7960())
            return stack;

        for (int i = 0; i < dest.getSlots(); i++) {
            stack = dest.insertItem(i, stack, simulate);
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
        }

        return stack;
    }

    public static class_1799 insertItemStacked(IItemHandler inventory, class_1799 stack, boolean simulate) {
        if (inventory == null || stack.method_7960())
            return stack;

        // not stackable -> just insert into a new slot
        if (!stack.method_7946()) {
            return insertItem(inventory, stack, simulate);
        }

        int sizeInventory = inventory.getSlots();

        // go through the inventory and try to fill up already existing items
        for (int i = 0; i < sizeInventory; i++) {
            class_1799 slot = inventory.getStackInSlot(i);
            if (class_1799.method_31577(slot, stack)) {
                stack = inventory.insertItem(i, stack, simulate);

                if (stack.method_7960()) {
                    break;
                }
            }
        }

        // insert remainder into empty slots
        if (!stack.method_7960()) {
            // find empty slot
            for (int i = 0; i < sizeInventory; i++) {
                if (inventory.getStackInSlot(i).method_7960()) {
                    stack = inventory.insertItem(i, stack, simulate);
                    if (stack.method_7960()) {
                        break;
                    }
                }
            }
        }

        return stack;
    }

    public static void giveItemToPlayer(class_1657 player, class_1799 stack) {
        giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(class_1657 player, class_1799 stack, int preferredSlot) {
        if (stack.method_7960()) return;

        IItemHandler inventory = new PlayerMainInvWrapper(player.method_31548());
        class_1937 level = player.method_37908();

        // try adding it into the inventory
        class_1799 remainder = stack;
        // insert into preferred slot first
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        // then into the inventory in general
        if (!remainder.method_7960()) {
            remainder = insertItemStacked(inventory, remainder, false);
        }

        // play sound if something got picked up
        if (remainder.method_7960() || remainder.method_7947() != stack.method_7947()) {
            level.method_43128(null, player.method_23317(), player.method_23318() + 0.5, player.method_23321(),
                    class_3417.field_15197, class_3419.field_15248, 0.2F, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7F + 1.0F) * 2.0F);
        }

        // drop remaining itemstack into the level
        if (!remainder.method_7960() && !level.field_9236) {
            class_1542 entityitem = new class_1542(level, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), remainder);
            entityitem.method_6982(40);
            entityitem.method_18799(entityitem.method_18798().method_18805(0, 1, 0));

            level.method_8649(entityitem);
        }
    }
}
