package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class ItemStackHandler implements IItemHandler, IItemHandlerModifiable, INBTSerializable<class_2487> {
    protected class_2371<class_1799> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        stacks = class_2371.method_10213(size, class_1799.field_8037);
    }

    public ItemStackHandler(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    @Override
    public void readFromNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        if (tag.method_10545(TAG_INVENTORY)) {
            this.deserializeNBT(registryLookup, tag.method_10562(TAG_INVENTORY));
        }
    }

    @Override
    public void writeToNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        tag.method_10566(TAG_INVENTORY, this.serializeNBT(registryLookup));
    }

    public void setSize(int size) {
        stacks = class_2371.method_10213(size, class_1799.field_8037);
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        validateSlotIndex(slot);
        this.stacks.set(slot, stack);
        onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return stacks.size();
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        validateSlotIndex(slot);
        return this.stacks.get(slot);
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (stack.method_7960())
            return class_1799.field_8037;

        if (!isItemValid(slot, stack))
            return stack;

        validateSlotIndex(slot);

        class_1799 existing = this.stacks.get(slot);

        int limit = getStackLimit(slot, stack);

        if (!existing.method_7960()) {
            if (!class_1799.method_31577(stack, existing))
                return stack;

            limit -= existing.method_7947();
        }

        if (limit <= 0)
            return stack;

        boolean reachedLimit = stack.method_7947() > limit;

        if (!simulate) {
            if (existing.method_7960()) {
                this.stacks.set(slot, reachedLimit ? stack.method_46651(limit) : stack);
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            onContentsChanged(slot);
        }

        return reachedLimit ? stack.method_46651(stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0)
            return class_1799.field_8037;

        validateSlotIndex(slot);

        class_1799 existing = this.stacks.get(slot);

        if (existing.method_7960())
            return class_1799.field_8037;

        int toExtract = Math.min(amount, existing.method_7914());

        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, class_1799.field_8037);
                onContentsChanged(slot);
                return existing;
            } else {
                return existing.method_7972();
            }
        } else {
            if (!simulate) {
                this.stacks.set(slot, existing.method_46651(existing.method_7947() - toExtract));
                onContentsChanged(slot);
            }

            return existing.method_46651(toExtract);
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        return class_1792.field_49998;
    }

    protected int getStackLimit(int slot, class_1799 stack) {
        return Math.min(getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    @Override
    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < stacks.size(); i++) {
            if (!stacks.get(i).method_7960()) {
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                nbtTagList.add(stacks.get(i).method_57376(provider, itemTag));
            }
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", nbtTagList);
        nbt.method_10569("Size", stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
        setSize(nbt.method_10573("Size", class_2520.field_33253) ? nbt.method_10550("Size") : stacks.size());
        class_2499 tagList = nbt.method_10554("Items", class_2520.field_33260);
        for (int i = 0; i < tagList.size(); i++) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");

            if (slot >= 0 && slot < stacks.size()) {
                class_1799.method_57360(provider, itemTags).ifPresent(stack -> stacks.set(slot, stack));
            }
        }
        onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= stacks.size())
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + stacks.size() + ")");
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}
