package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import com.google.common.base.Preconditions;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class RangedWrapper implements IItemHandlerModifiable {
    private final IItemHandlerModifiable compose;
    private final int minSlot;
    private final int maxSlot;

    public RangedWrapper(IItemHandlerModifiable compose, int minSlot, int maxSlotExclusive) {
        Preconditions.checkArgument(maxSlotExclusive > minSlot, "Max slot must be greater than min slot");
        this.compose = compose;
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    @Override
    public int getSlots() {
        return maxSlot - minSlot;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        if (checkSlot(slot)) {
            return compose.getStackInSlot(slot + minSlot);
        }

        return class_1799.field_8037;
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (checkSlot(slot)) {
            return compose.insertItem(slot + minSlot, stack, simulate);
        }

        return stack;
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (checkSlot(slot)) {
            return compose.extractItem(slot + minSlot, amount, simulate);
        }

        return class_1799.field_8037;
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        if (checkSlot(slot)) {
            compose.setStackInSlot(slot + minSlot, stack);
        }
    }

    @Override
    public int getSlotLimit(int slot) {
        if (checkSlot(slot)) {
            return compose.getSlotLimit(slot + minSlot);
        }

        return 0;
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        if (checkSlot(slot)) {
            return compose.isItemValid(slot + minSlot, stack);
        }

        return false;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot + minSlot < maxSlot;
    }

    @Override
    public void readFromNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        if (tag.method_10545(TAG_INVENTORY)) {
            this.deserializeNBT(registryLookup, tag.method_10562(TAG_INVENTORY));
        }
    }

    @Override
    public void writeToNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        tag.method_10566(TAG_INVENTORY, this.serializeNBT(registryLookup));
    }

    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < getSlots(); i++) {
            if (!getStackInSlot(i).method_7960()) {
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                nbtTagList.add(getStackInSlot(i).method_57376(provider, itemTag));
            }
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", nbtTagList);
        nbt.method_10569("Size", getSlots());
        return nbt;
    }

    public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
        int size = nbt.method_10573("Size", class_2520.field_33253) ? nbt.method_10550("Size") : getSlots();
        class_2499 tagList = nbt.method_10554("Items", class_2520.field_33260);
        for (int i = 0; i < tagList.size(); i++) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");

            if (slot >= 0 && slot < size) {
                class_1799.method_57360(provider, itemTags).ifPresent(stack -> setStackInSlot(slot, stack));
            }
        }
    }
}
