package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.item.ItemBoardState;
import com.github.tartaricacid.touhoulittlemaid.item.ItemHakureiGohei;
import com.github.tartaricacid.touhoulittlemaid.network.message.GomokuClientPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_702;
import net.minecraft.class_9062;
import net.minecraft.world.level.block.*;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;

public class BlockGomoku extends BlockJoy implements IBoardGameBlock, IBlock {
    public static final class_2754<GomokuPart> PART = class_2754.method_11850("part", GomokuPart.class);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_265 LEFT_UP = class_2248.method_9541(8, 0, 8, 16, 2, 16);
    public static final class_265 LEFT_UP_WITH_BOX = class_259.method_1084(LEFT_UP, class_2248.method_9541(11, 0, 2, 16, 4, 7));
    public static final class_265 UP = class_2248.method_9541(0, 0, 8, 16, 2, 16);
    public static final class_265 RIGHT_UP = class_2248.method_9541(0, 0, 8, 8, 2, 16);
    public static final class_265 RIGHT_UP_WITH_BOX = class_259.method_1084(RIGHT_UP, class_2248.method_9541(9, 0, 11, 14, 4, 16));
    public static final class_265 LEFT_CENTER = class_2248.method_9541(8, 0, 0, 16, 2, 16);
    public static final class_265 CENTER = class_2248.method_9541(0, 0, 0, 16, 2, 16);
    public static final class_265 RIGHT_CENTER = class_2248.method_9541(0, 0, 0, 8, 2, 16);
    public static final class_265 LEFT_DOWN = class_2248.method_9541(8, 0, 0, 16, 2, 8);
    public static final class_265 LEFT_DOWN_WITH_BOX = class_259.method_1084(LEFT_DOWN, class_2248.method_9541(2, 0, 0, 7, 4, 5));
    public static final class_265 DOWN = class_2248.method_9541(0, 0, 0, 16, 2, 8);
    public static final class_265 RIGHT_DOWN = class_2248.method_9541(0, 0, 0, 8, 2, 8);
    public static final class_265 RIGHT_DOWN_WITH_BOX = class_259.method_1084(RIGHT_DOWN, class_2248.method_9541(0, 0, 9, 5, 4, 14));

    public BlockGomoku() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0F, 3.0F).method_51369().method_22488());
        this.method_9590(this.field_10647.method_11664().method_11657(PART, GomokuPart.CENTER).method_11657(FACING, class_2350.field_11043));
    }

    private static void handleGomokuRemove(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            GomokuPart part = state.method_11654(PART);
            class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
            class_2586 te = world.method_8321(centerPos);
            method_9577(world, centerPos, InitItems.GOMOKU.method_7854());
            if (te instanceof TileEntityGomoku) {
                for (int i = -1; i < 2; i++) {
                    for (int j = -1; j < 2; j++) {
                        world.method_8501(centerPos.method_10069(i, 0, j), class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }

    @Nullable
    private static int[] getChessPos(double x, double y, GomokuPart part) {
        switch (part) {
            case LEFT_UP -> {
                return getData(x, y, 0.505, 0.505, 0.54, 0.54, 0, 0);
            }
            case UP -> {
                return getData(x, y, 0.037, 0.505, 0.08, 0.54, 4, 0);
            }
            case RIGHT_UP -> {
                return getData(x, y, -0.037, 0.505, -0.01, 0.54, 11, 0);
            }
            case LEFT_CENTER -> {
                return getData(x, y, 0.505, 0.037, 0.54, 0.07, 0, 4);
            }
            case CENTER -> {
                return getData(x, y, 0.037, 0.037, 0.08, 0.07, 4, 4);
            }
            case RIGHT_CENTER -> {
                return getData(x, y, -0.037, 0.037, -0.01, 0.07, 11, 4);
            }
            case LEFT_DOWN -> {
                return getData(x, y, 0.505, 0, 0.54, 0, 0, 11);
            }
            case DOWN -> {
                return getData(x, y, 0.037, 0, 0.08, 0, 4, 11);
            }
            case RIGHT_DOWN -> {
                return getData(x, y, -0.037, 0, -0.01, 0, 11, 11);
            }
            default -> {
                return null;
            }
        }
    }

    private static boolean isClickChessBox(double x, double y, GomokuPart part, class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11051) {
            if (part == GomokuPart.RIGHT_UP) {
                return 0.5625 <= x && x <= 0.875 && 0.6875 <= y && y <= 1;
            }
            if (part == GomokuPart.LEFT_DOWN) {
                return 0.125 <= x && x <= 0.4375 && 0 <= y && y <= 0.3125;
            }
        }
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            if (part == GomokuPart.LEFT_UP) {
                return 0.6875 <= x && x <= 1 && 0.125 <= y && y <= 0.4375;
            }
            if (part == GomokuPart.RIGHT_DOWN) {
                return 0 <= x && x <= 0.3125 && 0.5625 <= y && y <= 0.875;
            }
        }
        return false;
    }

    @Nullable
    private static int[] getData(double x, double y, double xOffset, double yOffset, double xStartOffset, double yStartOffset, int xIndexOffset, int yIndexOffset) {
        int xIndex = (int) ((x - xOffset) / 0.1316);
        int yIndex = (int) ((y - yOffset) / 0.1316);
        double xStart = xStartOffset + xIndex * 0.1316;
        double xEnd = xStart + 0.07;
        double yStart = yStartOffset + yIndex * 0.1316;
        double yEnd = yStart + 0.07;
        xIndex += xIndexOffset;
        yIndex += yIndexOffset;
        boolean checkIndex = 0 <= xIndex && xIndex <= 14 && 0 <= yIndex && yIndex <= 14;
        boolean checkClick = xStart < x && x < xEnd && yStart < y && y < yEnd;
        if (checkIndex && checkClick) {
            return new int[]{xIndex, yIndex};
        }
        return null;
    }

    @Override
    protected class_243 sitPosition() {
        return class_243.field_1353;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        handleGomokuRemove(world, pos, state);
        return super.method_9576(world, pos, state, player);
    }

    @Environment(EnvType.CLIENT)
    @Override
    public boolean tlm$addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        return false;
    }

    @Override
    public void tlm$onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        handleGomokuRemove(world, pos, state);
        IBlock.super.tlm$onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2338 centerPos = context.method_8037();
        for (int i = -1; i < 2; i++) {
            for (int j = -1; j < 2; j++) {
                class_2338 searchPos = centerPos.method_10069(i, 0, j);
                if (!context.method_8045().method_8320(searchPos).method_26166(context)) {
                    return null;
                }
            }
        }
        return this.method_9564().method_11657(FACING, context.method_8042().method_10153());
    }

    @Override
    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.field_9236) {
            return;
        }
        for (int i = -1; i < 2; i++) {
            for (int j = -1; j < 2; j++) {
                class_2338 searchPos = pos.method_10069(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part != null && !part.isCenter()) {
                    worldIn.method_8652(searchPos, state.method_11657(PART, part), class_2248.field_31036);
                }
            }
        }
    }

    @Override
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level instanceof class_3218 serverLevel && hand == class_1268.field_5808) {
            GomokuPart part = state.method_11654(PART);
            class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
            class_2586 te = level.method_8321(centerPos);
            if (!(te instanceof TileEntityGomoku gomoku)) {
                return class_9062.field_47733;
            }

            class_243 location = hit.method_17784().method_1023(pos.method_10263(), pos.method_10264(), pos.method_10260());
            class_2350 facing = state.method_11654(FACING);

            // 如果是创造模式，有特殊用法
            if (player.method_31549().field_7477) {
                class_9062 success = this.onCreativePlayerClick(level, pos, player, gomoku, centerPos, location, part, facing);
                if (success != null) {
                    return success;
                }
            }

            // 如果是残局道具，那么直接设置残局
            class_1799 heldItem = player.method_6047();
            if (heldItem.method_31574(InitItems.GOMOKU_BOARD_STATE)) {
                String[] boardState = ItemBoardState.getState(heldItem);
                if (boardState == null) {
                    return class_9062.field_47733;
                }
                String data = boardState[0];
                if (StringUtils.isEmpty(data)) {
                    return class_9062.field_47733;
                }
                gomoku.setStateData(GomokuCodec.decode(data));
                level.method_8396(null, pos, InitSounds.GOMOKU_RESET, class_3419.field_15245, 1.0f, 1.0f);
                return class_9062.field_47728;
            }

            // 然后是下棋，必须空手
            if (!itemStack.method_7960()) {
                return class_9062.field_47732;
            }

            if (isClickChessBox(location.field_1352, location.field_1350, part, facing)) {
                level.method_8396(null, centerPos, InitSounds.GOMOKU_RESET, class_3419.field_15245, 1.0f, 1.0f);
                gomoku.reset();
                gomoku.refresh();

                // 重置女仆棋类动画
                class_1297 sitEntity = serverLevel.method_14190(gomoku.getSitId());
                if (sitEntity != null && sitEntity.method_5805() && sitEntity.method_31483() instanceof EntityMaid maid) {
                    maid.getGameRecordManager().resetStatue();
                }

                return class_9062.field_47728;
            }
            class_1297 sitEntity = serverLevel.method_14190(gomoku.getSitId());
            if (sitEntity == null || !sitEntity.method_5805() || !(sitEntity.method_31483() instanceof EntityMaid maid)) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.gomoku.no_maid"));
                return class_9062.field_47733;
            }
            // 检查是不是自己的女仆
            if (MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get() && !maid.method_6171(player)) {
                player.method_43496(class_2561.method_43471("message.touhou_little_maid.gomoku.not_owner"));
                return class_9062.field_47733;
            }
            if (!gomoku.isPlayerTurn()) {
                return class_9062.field_47733;
            }
            byte[][] chessData = gomoku.getChessData();
            int[] clickPos = getChessPos(location.field_1352, location.field_1350, part);
            if (clickPos == null) {
                return class_9062.field_47733;
            }
            Point playerPoint = new Point(clickPos[0], clickPos[1], Point.BLACK);
            if (gomoku.getStatue() == Statue.IN_PROGRESS && chessData[playerPoint.x][playerPoint.y] == Point.EMPTY) {
                gomoku.setChessData(playerPoint.x, playerPoint.y, playerPoint.type);
                Statue statue = MaidGomokuAI.getStatue(chessData, playerPoint);
                // 但是和其他人的女仆对弈不加好感哦
                if (statue == Statue.WIN && maid.method_6171(player)) {
                    maid.getFavorabilityManager().apply(Type.GOMOKU_WIN);
                    maid.getGameRecordManager().markStatue(false);
                    int rankBefore = MaidGomokuAI.getRank(maid);
                    maid.getGameRecordManager().increaseGomokuWinCount();
                    int rankAfter = MaidGomokuAI.getRank(maid);
                    // 女仆升段啦
                    if (rankBefore < rankAfter) {
                        if (player instanceof class_3222 serverPlayer) {
                            ServerPlayNetworking.send(serverPlayer, new SpawnParticlePackage(maid.method_5628(), SpawnParticlePackage.Type.RANK_UP));
                        }
                    }
                    if (player instanceof class_3222 serverPlayer) {
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.WIN_GOMOKU);
                    }
                }
                gomoku.setStatue(statue);
                level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
                if (gomoku.getStatue() == Statue.IN_PROGRESS && player instanceof class_3222 serverPlayer) {
                    gomoku.setPlayerTurn(false);
                    ServerPlayNetworking.send(serverPlayer, new GomokuClientPackage(centerPos, chessData, playerPoint, maid.getGameRecordManager().getGomokuWinCount()));
                }
                gomoku.refresh();
                return class_9062.field_47728;
            }
        }
        return class_9062.field_47732;
    }

    @Nullable
    private class_9062 onCreativePlayerClick(class_1937 level, class_2338 pos, class_1657 player, TileEntityGomoku gomoku,
                                                        class_2338 centerPos, class_243 location, GomokuPart part, class_2350 facing) {
        class_1792 item = player.method_6047().method_7909();

        // 拿着御币点击，那么铺满棋盘，只剩三个位置，用来调试满棋盘
        if (item instanceof ItemHakureiGohei) {
            gomoku.clickWithDebug();
            gomoku.refresh();
            level.method_8396(null, centerPos, InitSounds.GOMOKU_RESET, class_3419.field_15245, 1.0f, 1.0f);
            return class_9062.field_47728;
        }

        // 如果是木棍，那么就是预设棋局模式
        if (item == class_1802.field_8600) {
            // 如果玩家点击的是棋盒，导出
            if (isClickChessBox(location.field_1352, location.field_1350, part, facing)) {
                String result = GomokuCodec.encode(gomoku.getStateData());
                class_5250 component = class_2564.method_47523(result);
                player.method_43496(component);
                return class_9062.field_47728;
            }

            // 否则就是预设棋局
            int[] clickPos = getChessPos(location.field_1352, location.field_1350, part);
            if (clickPos == null) {
                return class_9062.field_47733;
            }
            int type = gomoku.isPlayerTurn() ? Point.BLACK : Point.WHITE;
            Point playerPoint = new Point(clickPos[0], clickPos[1], type);
            gomoku.setChessData(playerPoint.x, playerPoint.y, playerPoint.type);
            level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8F + level.field_9229.method_43057() * 0.4F);
            gomoku.setPlayerTurn(!gomoku.isPlayerTurn());
            gomoku.refresh();
            return class_9062.field_47728;
        }

        return null;
    }

    @Override
    public void startMaidSit(EntityMaid maid, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218 serverLevel && worldIn.method_8321(pos) instanceof TileEntityJoy joy) {
            class_1297 oldSitEntity = serverLevel.method_14190(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.method_5805()) {
                return;
            }
            class_2350 face = state.method_11654(FACING).method_10170();
            class_243 position = new class_243(0.5 + face.method_10148() * 1.5, 0.1, 0.5 + face.method_10165() * 1.5);
            EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273(pos, position.field_1352, position.field_1351, position.field_1350), this.getTypeName(), pos);
            newSitEntity.method_36456(face.method_10153().method_10144() + this.sitYRot());
            worldIn.method_8649(newSitEntity);
            joy.setSitId(newSitEntity.method_5667());
            joy.method_5431();
            maid.method_5804(newSitEntity);
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(PART, FACING);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(PART).isCenter()) {
            return new TileEntityGomoku(pos, state);
        }
        return null;
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return method_54094((properties) -> new BlockGomoku());
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        switch (state.method_11654(PART)) {
            case LEFT_UP -> {
                if (state.method_11654(FACING).method_10166() == class_2350.class_2351.field_11048) {
                    return LEFT_UP_WITH_BOX;
                } else {
                    return LEFT_UP;
                }
            }
            case UP -> {
                return UP;
            }
            case RIGHT_UP -> {
                if (state.method_11654(FACING).method_10166() == class_2350.class_2351.field_11051) {
                    return RIGHT_UP_WITH_BOX;
                } else {
                    return RIGHT_UP;
                }
            }
            case LEFT_CENTER -> {
                return LEFT_CENTER;
            }
            case RIGHT_CENTER -> {
                return RIGHT_CENTER;
            }
            case LEFT_DOWN -> {
                if (state.method_11654(FACING).method_10166() == class_2350.class_2351.field_11051) {
                    return LEFT_DOWN_WITH_BOX;
                } else {
                    return LEFT_DOWN;
                }
            }
            case DOWN -> {
                return DOWN;
            }
            case RIGHT_DOWN -> {
                if (state.method_11654(FACING).method_10166() == class_2350.class_2351.field_11048) {
                    return RIGHT_DOWN_WITH_BOX;
                } else {
                    return RIGHT_DOWN;
                }
            }
            default -> {
                return CENTER;
            }
        }
    }
}
