package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.util.particle.ParticleUtil;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6088;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_727;
import net.minecraft.world.level.block.*;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

public class BlockStatue extends class_2248 implements class_2343, IBlock {
    public static final class_2746 IS_TINY = class_2746.method_11825("is_tiny");

    @Override
    public boolean tlm$addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        if (target instanceof class_3965 blockTarget && world instanceof class_638 clientWorld) {
            class_2338 pos = blockTarget.method_17777();
            this.crack(clientWorld, pos, class_2246.field_10460.method_9564(), blockTarget.method_17780());
        }
        return true;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public boolean tlm$addDestroyEffects(class_2680 state, class_1937 world, class_2338 pos, class_702 manager) {
        class_310.method_1551().field_1713.method_3046(pos, class_2246.field_10460.method_9564());
        return true;
    }

    @Environment(EnvType.CLIENT)
    private void crack(class_638 world, class_2338 pos, class_2680 state, class_2350 side) {
        if (state.method_26217() != class_2464.field_11455) {
            int posX = pos.method_10263();
            int posY = pos.method_10264();
            int posZ = pos.method_10260();
            class_238 aabb = state.method_26218(world, pos).method_1107();
            double x = posX + world.field_9229.method_43058() * (aabb.field_1320 - aabb.field_1323 - 0.2) + 0.1 + aabb.field_1323;
            double y = posY + world.field_9229.method_43058() * (aabb.field_1325 - aabb.field_1322 - 0.2) + 0.1 + aabb.field_1322;
            double z = posZ + world.field_9229.method_43058() * (aabb.field_1324 - aabb.field_1321 - 0.2) + 0.1 + aabb.field_1321;
            if (side == class_2350.field_11033) {
                y = posY + aabb.field_1322 - 0.1;
            }
            if (side == class_2350.field_11036) {
                y = posY + aabb.field_1325 + 0.1;
            }
            if (side == class_2350.field_11043) {
                z = posZ + aabb.field_1321 - 0.1;
            }
            if (side == class_2350.field_11035) {
                z = posZ + aabb.field_1324 + 0.1;
            }
            if (side == class_2350.field_11039) {
                x = posX + aabb.field_1323 - 0.1;
            }
            if (side == class_2350.field_11034) {
                x = posX + aabb.field_1320 + 0.1;
            }
            class_727 diggingParticle = new class_727(world, x, y, z, 0, 0, 0, state);
            class_310.method_1551().field_1713.method_3058(ParticleUtil.updateSprite(diggingParticle, state, pos).method_3075(0.2f).method_3087(0.6f));
        }
    }

    public BlockStatue() {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_37640).method_9629(1, 2).method_22488());
        this.method_9590(this.field_10647.method_11664().method_11657(IS_TINY, false));
    }

    @Override
    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        if (!worldIn.field_9236) {
            this.getStatue(worldIn, pos).ifPresent(statue -> {
                this.restoreClayBlock(worldIn, pos, statue);
                if (!player.method_7337()) {
                    class_2248.method_9577(worldIn, pos, new class_1799(class_2246.field_10460));
                }
            });
        }
        return super.method_9576(worldIn, pos, state, player);
    }

    @Override
    public void tlm$onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        if (!world.field_9236) {
            this.getStatue(world, pos).ifPresent(statue -> this.restoreClayBlock(world, pos, statue));
        }
        IBlock.super.tlm$onBlockExploded(state, world, pos, explosion);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(IS_TINY);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityStatue(pos, state);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    private Optional<TileEntityStatue> getStatue(class_1922 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof TileEntityStatue) {
            return Optional.of((TileEntityStatue) te);
        }
        return Optional.empty();
    }

    private void restoreClayBlock(@Nonnull class_1937 worldIn, @Nonnull class_2338 pos, TileEntityStatue statue) {
        List<class_2338> posList = statue.getAllBlocks();
        for (class_2338 storagePos : posList) {
            if (!storagePos.equals(pos)) {
                getStatue(worldIn, storagePos).ifPresent(s -> worldIn.method_8652(storagePos, class_2246.field_10460.method_9564(), class_2248.field_31036));
            }
        }
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return state.method_11654(IS_TINY);
    }

    @Override
    public void method_9514(class_2680 state, class_3218 worldIn, class_2338 pos, class_5819 random) {
        if (worldIn.method_8320(pos.method_10074()).method_27852(class_2246.field_10036)) {
            getStatue(worldIn, pos).ifPresent(statue -> {
                worldIn.method_8501(pos, InitBlocks.GARAGE_KIT.method_9564());
                {
                    worldIn.method_20290(class_6088.field_31167, pos, 0);
                }
                class_2586 te = worldIn.method_8321(pos);
                if (te instanceof TileEntityGarageKit && statue.getExtraMaidData() != null) {
                    ((TileEntityGarageKit) te).setData(statue.getFacing(), statue.getExtraMaidData());
                }
            });
        }
    }
}
