package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.model.DebugFloorModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.Rectangle;
import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Quaternionf;

import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_898;

public abstract class AbstractModelDetailsGui<T extends class_1309, E extends IModelInfo> extends class_437 {
    private static final class_2960 BUTTON_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/skin_detail.png");
    private static final class_2960 FLOOR_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/debug_floor.png");

    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;

    private static final float SCALE_MAX = 360f;
    private static final float SCALE_MIN = 18f;
    private static final float PITCH_MAX = 90f;
    private static final float PITCH_MIN = -90f;

    private static Rectangle BACKGROUND_SIZE;
    private static Rectangle BOTTOM_STATUS_BAR_SIZE;
    private static Rectangle SIDE_MENU_SIZE;
    private static Rectangle TOP_STATUS_BAR_SIZE;

    protected final DebugFloorModel floorModel;

    protected T sourceEntity;
    protected volatile T guiEntity;
    protected E modelInfo;

    private float posX = 0;
    private float posY = 25;
    private float scale = 80;
    private float yaw = 145;
    private float pitch = 0;
    private boolean showFloor = true;

    public AbstractModelDetailsGui(T sourceEntity, @Nullable T guiEntity, E modelInfo) {
        super(class_2561.method_43471("gui.touhou_little_maid.custom_model_details_gui.title"));
        this.sourceEntity = sourceEntity;
        this.guiEntity = guiEntity;
        this.modelInfo = modelInfo;
        this.floorModel = new DebugFloorModel(class_310.method_1551().method_31974().method_32072(DebugFloorModel.LAYER));
    }

    /**
     * Click return button action
     */
    abstract protected void applyReturnButtonLogic();

    /**
     * Init side button
     */
    abstract protected void initSideButton();

    /**
     * Render extra entity in main window
     *
     * @param manager  EntityRenderDispatcher
     * @param matrix   PoseStack
     * @param bufferIn MultiBufferSource
     */
    abstract protected void renderExtraEntity(class_898 manager, class_4587 matrix, class_4597.class_4598 bufferIn);

    @Override
    protected void method_25426() {
        this.method_37067();

        BACKGROUND_SIZE = new Rectangle(0, 0, field_22789, field_22790);
        BOTTOM_STATUS_BAR_SIZE = new Rectangle(0, field_22790 - 16, field_22789, field_22790);
        SIDE_MENU_SIZE = new Rectangle(0, 0, 132, field_22790);
        TOP_STATUS_BAR_SIZE = new Rectangle(0, 0, field_22789, 15);

        TouhouImageButton closeButton = new TouhouImageButton(field_22789 - 15, 0, 15, 15,
                0, 24, 15, BUTTON_TEXTURE, b -> class_310.method_1551().method_1507(null));
        TouhouImageButton floorButton = new TouhouImageButton(field_22789 - 30, 0, 15, 15,
                30, 24, 15, BUTTON_TEXTURE, b -> showFloor = !showFloor);
        TouhouImageButton returnButton = new TouhouImageButton(field_22789 - 45, 0, 15, 15,
                15, 24, 15, BUTTON_TEXTURE, b -> applyReturnButtonLogic());
        method_37063(closeButton);
        method_37063(floorButton);
        method_37063(returnButton);

        this.initSideButton();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (field_22787 == null) {
            return;
        }
        this.renderViewBg(graphics);
        this.renderEntity((field_22789 + 132) / 2, field_22790 / 2 + 50, graphics);
        this.renderBottomStatueBar(graphics);
        this.fillGradient(graphics, SIDE_MENU_SIZE, 0xfe21252b);
        this.fillGradient(graphics, TOP_STATUS_BAR_SIZE, 0xfe282c34);
        graphics.method_27535(field_22793, method_25440(), 6, 4, 0xffaaaaaa);
        for (class_4068 renderable : ((ScreenAccessor) this).tlm$getRenderables()) {
            renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void renderViewBg(class_332 graphics) {
        this.fillGradient(graphics, BACKGROUND_SIZE, 0xfe17191d, -999);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0, 0, -900);
        graphics.method_51439(field_22793, class_2561.method_43471("gui.touhou_little_maid.skin_details.left_mouse"), (int) SIDE_MENU_SIZE.w + 4, (int) TOP_STATUS_BAR_SIZE.h + 4, 0xffaaaaaa, false);
        graphics.method_51439(field_22793, class_2561.method_43471("gui.touhou_little_maid.skin_details.right_mouse"), (int) SIDE_MENU_SIZE.w + 4, (int) TOP_STATUS_BAR_SIZE.h + 14, 0xffaaaaaa, false);
        graphics.method_51439(field_22793, class_2561.method_43471("gui.touhou_little_maid.skin_details.mouse_wheel"), (int) SIDE_MENU_SIZE.w + 4, (int) TOP_STATUS_BAR_SIZE.h + 24, 0xffaaaaaa, false);
        graphics.method_51448().method_22909();
    }

    private void renderBottomStatueBar(class_332 graphics) {
        this.fillGradient(graphics, BOTTOM_STATUS_BAR_SIZE, 0xfe282c34);
        String name = String.format("%s %s", "✔", class_1074.method_4662(ParseI18n.getI18nKey(modelInfo.getName())));
        String info = String.format("%d FPS %.2f%%", class_310.field_1738, scale * 100 / 80);
        graphics.method_51433(field_22793, name, 136, this.field_22790 - 12, 0xcacad4, false);
        graphics.method_51433(field_22793, info, this.field_22789 - field_22793.method_1727(info) - 4, this.field_22790 - 12, 0xcacad4, false);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean isInWidthRange = 132 < mouseX && mouseX < field_22789 - 1;
        boolean isInHeightRange = 15 < mouseY && mouseY < field_22790 - 16;
        boolean isInRange = isInWidthRange && isInHeightRange;
        if (field_22787 == null || !isInRange) {
            return false;
        }
        if (button == LEFT_MOUSE_BUTTON) {
            yaw += dragX;
            changePitchValue((float) dragY);
        }
        if (button == RIGHT_MOUSE_BUTTON) {
            posX += dragX;
            posY += dragY;
        }
        return true;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        boolean isInWidthRange = 132 < mouseX && mouseX < field_22789 - 1;
        boolean isInHeightRange = 15 < mouseY && mouseY < field_22790 - 16;
        boolean isInRange = isInWidthRange && isInHeightRange;
        if (field_22787 == null || !isInRange) {
            return false;
        }
        if (deltaY != 0) {
            changeScaleValue((float) deltaY * 0.07f);
            return true;
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void changePitchValue(float amount) {
        if (pitch - amount > PITCH_MAX) {
            pitch = 90;
        } else if (pitch - amount < PITCH_MIN) {
            pitch = -90;
        } else {
            pitch = pitch - amount;
        }
    }

    private void changeScaleValue(float amount) {
        float tmp = scale + amount * scale;
        scale = class_3532.method_15363(tmp, SCALE_MIN, SCALE_MAX);
    }


    private void renderEntity(int middleWidth, int middleHeight, class_332 graphics) {
        graphics.method_44379(132, 15, this.field_22789, this.field_22790 - 16);

        class_4587 viewStack = graphics.method_51448();
        viewStack.method_22903();
        viewStack.method_22904(0, 0, 1050.0D);
        viewStack.method_22905(1.0F, 1.0F, -1.0F);
        RenderSystem.applyModelViewMatrix();

        class_4587 poseStack = new class_4587();
        poseStack.method_22904(posX + middleWidth, posY + middleHeight, 1000.0D);
        poseStack.method_22905(scale, scale, -scale);

        Quaternionf zp = class_7833.field_40718.rotationDegrees(-180.0F);
        Quaternionf yp = class_7833.field_40716.rotationDegrees(yaw);
        Quaternionf xp = class_7833.field_40714.rotationDegrees(-pitch);
        yp.mul(xp);
        zp.mul(yp);
        poseStack.method_22907(zp);

        class_308.method_34742();
        class_898 manager = class_310.method_1551().method_1561();
        xp.conjugate();
        manager.method_24196(xp);
        manager.method_3948(false);
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> {
            manager.method_3954(guiEntity, 0, 0, 0, 0, class_310.method_1551().method_60646().method_60637(false), poseStack, buffer, 0xf000f0);
            poseStack.method_22904(0, 0.5, 0);
            if (showFloor) {
                this.floorModel.renderToBuffer(poseStack, buffer.getBuffer(this.floorModel.method_23500(FLOOR_TEXTURE)), 0xf000f0, class_4608.field_21444, 1.0F, 1.0F, 1.0F, 1.0F);
            }
            this.renderExtraEntity(manager, poseStack, buffer);
        });
        buffer.method_22993();
        manager.method_3948(true);

        viewStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        graphics.method_44380();
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private void fillGradient(class_332 graphics, Rectangle vec4d, int color) {
        graphics.method_25296((int) vec4d.x, (int) vec4d.y, (int) vec4d.w, (int) vec4d.h, color, color);
    }

    private void fillGradient(class_332 graphics, Rectangle vec4d, int color, int zLevel) {
        graphics.method_33284((int) vec4d.x, (int) vec4d.y, (int) vec4d.w, (int) vec4d.h, zLevel, color, color);
    }
}
