package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.detail;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ModelDetailsButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;

public class MaidModelDetailsGui extends AbstractModelDetailsGui<EntityMaid, MaidModelInfo> {
    private static final class_1799 MAIN_HAND_SWORD = class_1802.field_8802.method_7854();
    private static final class_1799 OFF_HAND_SHIELD = class_1802.field_8255.method_7854();
    private static final class_1799 ARMOR_ITEM = class_1802.field_8862.method_7854();
    private EntityChair chair;
    private volatile boolean isEnableWalk = false;

    public MaidModelDetailsGui(EntityMaid sourceEntity, MaidModelInfo modelInfo) {
        super(sourceEntity, InitEntities.MAID.method_5883(sourceEntity.method_37908()), modelInfo);
        this.guiEntity.setModelId(modelInfo.getModelId().toString());
        this.guiEntity.method_24830(true);
        this.guiEntity.field_6241 = 0;
        this.guiEntity.field_6259 = 0;
        this.initChair();
    }

    private void initChair() {
        if (class_310.method_1551().field_1687 != null) {
            this.chair = InitEntities.CHAIR.method_5883(class_310.method_1551().field_1687);
            if (this.chair != null) {
                this.chair.setModelId("touhou_little_maid:low_stool");
            }
        }
    }

    @Override
    protected void applyReturnButtonLogic() {
        CacheIconManager.openMaidModelGui(sourceEntity);
    }

    @Override
    protected void initSideButton() {
        ModelDetailsButton begButton = new ModelDetailsButton(2, 17, "gui.touhou_little_maid.skin_details.beg",
                (isStateTriggered) -> guiEntity.setBegging(isStateTriggered));
        ModelDetailsButton walkButton = new ModelDetailsButton(2, 17 + 13, "gui.touhou_little_maid.skin_details.walk",
                (isStateTriggered) -> isEnableWalk = isStateTriggered);
        ModelDetailsButton sitButton = new ModelDetailsButton(2, 17 + 13 * 2, "gui.touhou_little_maid.skin_details.sit",
                (isStateTriggered) -> guiEntity.method_6179(isStateTriggered));
        ModelDetailsButton rideButton = new ModelDetailsButton(2, 17 + 13 * 3, "gui.touhou_little_maid.skin_details.ride",
                this::applyRideButtonLogic);
        ModelDetailsButton helmetButton = new ModelDetailsButton(2, 17 + 13 * 4, "gui.touhou_little_maid.skin_details.helmet",
                (isStateTriggered) -> applyEquipmentButtonLogic(class_1304.field_6169, isStateTriggered));
        ModelDetailsButton chestPlateButton = new ModelDetailsButton(2, 17 + 13 * 5, "gui.touhou_little_maid.skin_details.chest_plate",
                (isStateTriggered) -> applyEquipmentButtonLogic(class_1304.field_6174, isStateTriggered));
        ModelDetailsButton leggingsButton = new ModelDetailsButton(2, 17 + 13 * 6, "gui.touhou_little_maid.skin_details.leggings",
                (isStateTriggered) -> applyEquipmentButtonLogic(class_1304.field_6172, isStateTriggered));
        ModelDetailsButton bootsButton = new ModelDetailsButton(2, 17 + 13 * 7, "gui.touhou_little_maid.skin_details.boots",
                (isStateTriggered) -> applyEquipmentButtonLogic(class_1304.field_6166, isStateTriggered));
        ModelDetailsButton mainHandButton = new ModelDetailsButton(2, 17 + 13 * 8, "gui.touhou_little_maid.skin_details.main_hand",
                (isStateTriggered) -> applyEquipmentButtonLogic(class_1304.field_6173, isStateTriggered));
        ModelDetailsButton offHandButton = new ModelDetailsButton(2, 17 + 13 * 9, "gui.touhou_little_maid.skin_details.off_hand",
                (isStateTriggered) -> applyEquipmentButtonLogic(class_1304.field_6171, isStateTriggered));
        this.method_37063(begButton);
        this.method_37063(walkButton);
        this.method_37063(sitButton);
        this.method_37063(rideButton);
        this.method_37063(helmetButton);
        this.method_37063(chestPlateButton);
        this.method_37063(leggingsButton);
        this.method_37063(bootsButton);
        this.method_37063(mainHandButton);
        this.method_37063(offHandButton);
    }

    @Override
    public void method_25393() {
        // Tick count increment for some animations
        guiEntity.field_6012++;
        // For entity walk
        // Update walk speed
        float speed = isEnableWalk ? 0.5f : 0;
        guiEntity.field_42108.method_48568(speed, 0.4f);
    }

    @Override
    protected void renderExtraEntity(class_898 manager, class_4587 matrix, class_4597.class_4598 bufferIn) {
        if (guiEntity.method_5765() && chair != null) {
            manager.method_3954(chair, 0, -0.95, 0, 0, 1, matrix, bufferIn, 0xf000f0);
        }
    }

    private void applyRideButtonLogic(boolean isStateTriggered) {
        if (isStateTriggered && chair != null) {
            guiEntity.method_5873(chair, true);
        } else {
            guiEntity.method_29239();
        }
    }

    private void applyEquipmentButtonLogic(class_1304 slot, boolean isStateTriggered) {
        if (isStateTriggered) {
            if (slot == class_1304.field_6173) {
                guiEntity.method_5673(slot, MAIN_HAND_SWORD);
            } else if (slot == class_1304.field_6171) {
                guiEntity.method_5673(slot, OFF_HAND_SHIELD);
            } else {
                guiEntity.method_5673(slot, ARMOR_ITEM);
            }
        } else {
            guiEntity.method_5673(slot, class_1799.field_8037);
        }
    }
}
