package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTaskEnableEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.MaidContainerGuiEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.MaidSoundPackGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.*;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.compat.ipn.SortButtonScreen;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.event.OpenYsmMaidScreenEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidTaskPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.RequestEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3544;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import static com.github.tartaricacid.touhoulittlemaid.util.GuiTools.NO_ACTION;

public abstract class AbstractMaidContainerGui<T extends AbstractMaidContainer> extends class_465<T> {
    private static final class_2960 BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_main.png");
    private static final class_2960 SIDE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_side.png");
    private static final class_2960 BUTTON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_button.png");
    private static final class_2960 TASK = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_task.png");

    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");

    private static final int TASK_COUNT_PER_PAGE = 12;
    private static int TASK_PAGE = 0;
    private static boolean TASK_LIST_OPEN = false;

    protected final EntityMaid maid;
    protected final IMaidTask task;
    /**
     * 非隐藏的任务列表，用于任务切换按钮显示
     */
    protected final List<IMaidTask> notHiddenTasks;

    /**
     * 事件系统添加的额外按钮
     */
    private final Map<String, class_339> eventAddButtons = Maps.newHashMap();

    private TouhouStateSwitchButton home;
    private TouhouStateSwitchButton pick;
    private TouhouStateSwitchButton ride;
    private TouhouImageButton info;
    private TouhouImageButton skin;
    private @Nullable TouhouImageButton ysmSkin;
    private TouhouImageButton sound;
    private TouhouImageButton pageDown;
    private TouhouImageButton pageUp;
    private TouhouImageButton pageClose;
    private TouhouImageButton taskSwitch;
    private MaidDownloadButton modelDownload;
    private ScheduleButton<T> scheduleButton;

    private int counterTime = 0;

    public AbstractMaidContainerGui(T screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        this.field_2779 = 256;
        this.field_2792 = 256;
        this.maid = field_2797.getMaid();
        this.task = field_2797.getMaid().getTask();
        this.notHiddenTasks = TaskManager.getNotHiddenTaskList(this.maid);
    }

    @Override
    protected void method_37067() {
        super.method_37067();
        this.eventAddButtons.clear();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        // fixme: https://github.com/TartaricAcid/TouhouLittleMaid/issues/416
        // 临时修复，应该采用更好的办法！
        if (this.maid == null) {
            return;
        }
        // 清除当前 Gui 的各种 Widgets
        this.method_37067();
        // 初始化基础 Data
        this.initBaseData();
        // 初始化额外 Data
        this.initAdditionData();
        // 初始化各种 Widgets
        this.initBaseWidgets();
        // 初始化额外 Widgets
        this.initAdditionWidgets();
        // 事件系统，用于其他模型添加额外的按钮
        MaidContainerGuiEvent.INIT.invoker().onInit(new MaidContainerGuiEvent.Init(this, field_2776, field_2800, this.eventAddButtons));
        this.eventAddButtons.values().forEach(this::method_37063);
    }

    protected void initBaseData() {
    }

    protected void initAdditionData() {
    }

    protected void initBaseWidgets() {
        this.addHomeButton();
        this.addPickButton();
        this.addRideButton();
        this.addDownloadButton();
        this.addStateButton();
        this.addTaskSwitchButton();
        this.addTaskControlButton();
        this.addTaskListButton();
        this.addScheduleButton();
        this.addTabsButton();
        this.addSideTabsButton();
    }

    protected void initAdditionWidgets() {
    }

    @Override
    @SuppressWarnings("all")
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        // fixme: https://github.com/TartaricAcid/TouhouLittleMaid/issues/416
        // 临时修复，应该采用更好的办法！
        if (this.maid == null) {
            return;
        }
        this.drawModInfo(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        drawModInfo(graphics);
        this.drawEffectInfo(graphics);
        this.drawCurrentTaskText(graphics);
        this.renderAddition(graphics, mouseX, mouseY, partialTicks);
        MaidContainerGuiEvent.RENDER.invoker().onRender(new MaidContainerGuiEvent.Render(this, field_2776, field_2800,
                this.eventAddButtons, graphics, mouseX, mouseY, partialTicks));
        // 确保 Tooltip 是最后渲染的
        this.method_2380(graphics, mouseX, mouseY);
        MaidContainerGuiEvent.TOOLTIP.invoker().onTooltip(new MaidContainerGuiEvent.Tooltip(this, field_2776, field_2800,
                this.eventAddButtons, graphics, mouseX, mouseY, partialTicks));
    }

    // 其他的渲染
    protected void renderAddition(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    // 增加一些额外信息，通过截图就能方便作者检查错误
    @SuppressWarnings("all")
    private void drawModInfo(class_332 graphics) {
        String minecraftVersion = class_155.method_16673().method_48019();
        String modVersion = FabricLoader.getInstance().getModContainer(TouhouLittleMaid.MOD_ID).get().getMetadata().getVersion().getFriendlyString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        graphics.method_25300(field_22793, debugInfo, field_2776 + 80 / 2, field_2800 - 4, class_124.field_1080.method_532());
    }

    @SuppressWarnings("all")
    private void drawEffectInfo(class_332 graphics) {
        if (TASK_LIST_OPEN) {
            return;
        }
        List<SendEffectPackage.EffectData> effects = maid.getEffects();
        if (!effects.isEmpty()) {
            int yOffset = 5;
            for (SendEffectPackage.EffectData effect : effects) {
                class_5250 text = class_2561.method_43471(effect.descriptionId());
                if (effect.amplifier() >= 1 && effect.amplifier() <= 9) {
                    class_5250 levelText = class_2561.method_43471("enchantment.level." + (effect.amplifier() + 1));
                    text = text.method_10852(class_5244.field_41874).method_10852(levelText);
                }
                String duration;
                if (effect.duration() == -1) {
                    duration = class_1074.method_4662("effect.duration.infinite");
                } else {
                    duration = class_3544.method_15439(effect.duration(), 20);
                }
                text = text.method_10852(class_5244.field_41874).method_27693(duration);
                graphics.method_27535(field_22793, text, field_2776 - field_22793.method_27525(text) - 3, field_2800 + yOffset + 5, getPotionColor(effect.category()));
                yOffset += 10;
            }
        }
    }

    @SuppressWarnings("all")
    private int getPotionColor(int category) {
        switch (category) {
            case 0:
                return class_124.field_1060.method_532();
            case 1:
                return class_124.field_1061.method_532();
            default:
                return class_124.field_1078.method_532();
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        graphics.method_25302(BG, field_2776, field_2800, 0, 0, field_2792, field_2779);
        SortButtonScreen.renderBackground(graphics, field_2776 + 249, field_2800 + 166);
        this.drawMaidCharacter(graphics, x, y);
        this.drawBaseInfoGui(graphics);
        this.drawTaskListBg(graphics);
        this.drawSideTabGui(graphics, partialTicks, x, y);
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        graphics.method_51448().method_22903();
        super.method_2380(graphics, x, y);
        renderTransTooltip(home, graphics, x, y, "gui.touhou_little_maid.button.home");
        renderTransTooltip(pick, graphics, x, y, "gui.touhou_little_maid.button.pickup");
        renderTransTooltip(ride, graphics, x, y, "gui.touhou_little_maid.button.maid_riding_set");
        renderTransTooltip(modelDownload, graphics, x, y, "gui.touhou_little_maid.button.model_download");
        renderTransTooltip(skin, graphics, x, y, "gui.touhou_little_maid.button.skin");
        if (ysmSkin != null) {
            renderTransTooltip(ysmSkin, graphics, x, y, "gui.touhou_little_maid.button.ysm_skin");
        }
        renderTransTooltip(sound, graphics, x, y, "gui.touhou_little_maid.button.sound");
        renderTransTooltip(pageUp, graphics, x, y, "gui.touhou_little_maid.task.previous_page");
        renderTransTooltip(pageDown, graphics, x, y, "gui.touhou_little_maid.task.next_page");
        renderTransTooltip(pageClose, graphics, x, y, "gui.touhou_little_maid.task.close");
        renderTransTooltip(taskSwitch, graphics, x, y, "gui.touhou_little_maid.task.switch");
        renderAdditionTransTooltip(graphics, x, y);
        renderMaidInfo(graphics, x, y);
        renderScheduleInfo(graphics, x, y);
        renderTaskButtonInfo(graphics, x, y);
        modelDownload.renderExtraTips(graphics);
        graphics.method_51448().method_22909();
    }

    // 渲染额外的 Tooltip
    protected void renderAdditionTransTooltip(class_332 graphics, int x, int y) {
    }

    @Override
    protected void method_2388(class_332 graphics, int x, int y) {
        this.drawTaskPageCount(graphics);
    }

    private void addStateButton() {
        skin = new TouhouImageButton(field_2776 + 62, field_2800 + 14, 9, 9, 72, 43, 10, BUTTON, (b) -> CacheIconManager.openMaidModelGui(maid));
        info = new TouhouImageButton(field_2776 + 8, field_2800 + 14, 9, 9, 72, 65, 10, BUTTON, NO_ACTION);
        this.method_37063(skin);
        this.method_37063(info);

        if (YsmCompat.isInstalled()) {
            this.ysmSkin = new TouhouImageButton(field_2776 + 52, field_2800 + 14, 9, 9,
                    144, 65, 10, BUTTON,
                    (b) -> OpenYsmMaidScreenEvent.CALLBACK.invoker().post(new OpenYsmMaidScreenEvent(maid)));
            this.sound = new TouhouImageButton(field_2776 + 42, field_2800 + 14, 9, 9,
                    144, 43, 10, BUTTON,
                    (b) -> Screens.getClient(this).method_1507(new MaidSoundPackGui(maid)));

            this.method_37063(ysmSkin);
            this.method_37063(sound);
        } else {
            this.sound = new TouhouImageButton(field_2776 + 52, field_2800 + 14, 9, 9,
                    144, 43, 10, BUTTON,
                    (b) -> Screens.getClient(this).method_1507(new MaidSoundPackGui(maid)));
            this.method_37063(sound);
        }
    }

    private void addTaskControlButton() {
        pageDown = new TouhouImageButton(field_2776 - 72, field_2800 + 9, 16, 13, 93, 0, 14, TASK, (b) -> {
            taskPageDown();
        });
        pageUp = new TouhouImageButton(field_2776 - 89, field_2800 + 9, 16, 13, 110, 0, 14, TASK, (b) -> {
            taskPageUp();
        });
        pageClose = new TouhouImageButton(field_2776 - 19, field_2800 + 9, 13, 13, 127, 0, 14, TASK, (b) -> {
            TASK_LIST_OPEN = false;
            method_25426();
        });
        this.method_37063(pageUp);
        this.method_37063(pageDown);
        this.method_37063(pageClose);
        pageUp.field_22764 = TASK_LIST_OPEN;
        pageDown.field_22764 = TASK_LIST_OPEN;
        pageClose.field_22764 = TASK_LIST_OPEN;
    }

    private void taskPageUp() {
        if (TASK_PAGE > 0) {
            TASK_PAGE--;
            method_25426();
        }
    }

    private void taskPageDown() {
        if (TASK_PAGE * TASK_COUNT_PER_PAGE + TASK_COUNT_PER_PAGE < notHiddenTasks.size()) {
            TASK_PAGE++;
            method_25426();
        }
    }

    private void addTaskListButton() {
        if (TASK_PAGE * TASK_COUNT_PER_PAGE >= notHiddenTasks.size()) {
            TASK_PAGE = 0;
        }
        for (int count = 0; count < TASK_COUNT_PER_PAGE; count++) {
            int index = TASK_PAGE * TASK_COUNT_PER_PAGE + count;
            if (index < notHiddenTasks.size()) {
                drawPerTaskButton(notHiddenTasks, count, index);
            }
        }
    }

    private void drawPerTaskButton(List<IMaidTask> tasks, int count, int index) {
        final IMaidTask maidTask = tasks.get(index);
        boolean[] enable = {true};
        List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc = Lists.newArrayList();
        if (maidTask != TaskManager.getIdleTask()) {
            MaidTaskEnableEvent event = new MaidTaskEnableEvent(maidTask, maid, enableConditionDesc);
            MaidTaskEnableEvent.CALLBACK.invoker().onMaidTaskEnable(event);
            if (event.isCanceled()) {
                // 如果事件系统管控了启用条件
                enable[0] = false;
            } else if (!maidTask.isEnable(maid)) {
                // 如果 task 里的条件也不启用
                enableConditionDesc.addAll(maidTask.getEnableConditionDesc(maid));
                enable[0] = false;
            }
        }

        TaskButton button = new TaskButton(maidTask, enable[0], field_2776 - 89, field_2800 + 23 + 19 * count,
                83, 19, 93, 28, 20, TASK, 256, 256,
                b -> taskButtonPressed(maidTask, enable[0]),
                getTaskTooltips(maidTask, enable[0], enableConditionDesc), class_2561.method_43473());
        this.method_37063(button);
        button.field_22764 = TASK_LIST_OPEN;
    }

    // 用于开放切换任务时对当前 GUI 的操作
    protected void taskButtonPressed(IMaidTask maidTask, boolean enable) {
        if (enable && maid != null) {
            maid.setTask(maidTask);
            ClientPlayNetworking.send(new MaidTaskPackage(maid.method_5628(), maidTask.getUid()));
        }
    }

    private List<class_2561> getTaskTooltips(IMaidTask maidTask, boolean enable, List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc) {
        List<class_2561> desc = ParseI18n.keysToTrans(maidTask.getDescription(maid), class_124.field_1080);
        if (!desc.isEmpty()) {
            desc.addFirst(class_2561.method_43471("task.touhou_little_maid.desc.title").method_27692(class_124.field_1065));
        }
        if (!enable) {
            // 强制显示启用条件提示
            desc.add(class_2561.method_43470(" "));
            desc.add(class_2561.method_43471("task.touhou_little_maid.desc.enable_condition").method_27692(class_124.field_1065));

            for (Pair<String, Predicate<EntityMaid>> line : enableConditionDesc) {
                class_5250 prefix = class_2561.method_43470("- ");
                String key = String.format("task.%s.%s.enable_condition.%s", maidTask.getUid().method_12836(), maidTask.getUid().method_12832(), line.getFirst());
                class_5250 condition = class_2561.method_43471(key);
                if (line.getSecond().test(maid)) {
                    condition.method_27692(class_124.field_1060);
                } else {
                    condition.method_27692(class_124.field_1061);
                }
                desc.add(prefix.method_10852(condition));
            }
        }
        List<Pair<String, Predicate<EntityMaid>>> conditions = maidTask.getConditionDescription(maid);
        if (!conditions.isEmpty()) {
            desc.add(class_2561.method_43470(" "));
            desc.add(class_2561.method_43471("task.touhou_little_maid.desc.condition").method_27692(class_124.field_1065));
        }
        for (Pair<String, Predicate<EntityMaid>> line : conditions) {
            class_5250 prefix = class_2561.method_43470("- ");
            String key = String.format("task.%s.%s.condition.%s", maidTask.getUid().method_12836(), maidTask.getUid().method_12832(), line.getFirst());
            class_5250 condition = class_2561.method_43471(key);
            if (line.getSecond().test(maid)) {
                condition.method_27692(class_124.field_1060);
            } else {
                condition.method_27692(class_124.field_1061);
            }
            desc.add(prefix.method_10852(condition));
        }
        if (Screens.getClient(this).field_1690.field_1827) {
            desc.add(class_5244.field_41874);
            desc.add(class_2561.method_43469("task.touhou_little_maid.advanced.id", maidTask.getUid().method_12832()).method_27692(class_124.field_1063));
        }
        return desc;
    }

    private void addScheduleButton() {
        scheduleButton = new ScheduleButton<>(field_2776 + 9, field_2800 + 187, this);
        this.method_37063(scheduleButton);
    }

    private void addTabsButton() {
        MaidTabs<T> maidTabs = new MaidTabs<>(maid.method_5628(), field_2776, field_2800);
        MaidTabButton[] tabs = maidTabs.getTabs(this);
        for (MaidTabButton button : tabs) {
            this.method_37063(button);
        }
    }

    private void addTaskSwitchButton() {
        taskSwitch = new TouhouImageButton(field_2776 + 4, field_2800 + 159, 71, 21, 0, 42, 22, BUTTON, (b) -> {
            TASK_LIST_OPEN = !TASK_LIST_OPEN;
            method_25426();
        });
        this.method_37063(taskSwitch);
    }

    private void addRideButton() {
        ride = new TouhouStateSwitchButton(field_2776 + 51, field_2800 + 206, 20, 20, maid.isRideable()) {
            @Override
            public void method_25348(double mouseX, double mouseY) {
                this.isStateTriggered = !this.isStateTriggered;
                ClientPlayNetworking.send(new MaidConfigPackage(maid.method_5628(), maid.isHomeModeEnable(), maid.isPickup(), isStateTriggered, maid.getSchedule()));
            }
        };
        ride.initTextureValues(84, 0, 21, 21, BUTTON);
        this.method_37063(ride);
    }

    private void addPickButton() {
        pick = new TouhouStateSwitchButton(field_2776 + 30, field_2800 + 206, 20, 20, maid.isPickup()) {
            @Override
            public void method_25348(double mouseX, double mouseY) {
                this.isStateTriggered = !this.isStateTriggered;
                ClientPlayNetworking.send(new MaidConfigPackage(maid.method_5628(), maid.isHomeModeEnable(), isStateTriggered, maid.isRideable(), maid.getSchedule()));
            }
        };
        pick.initTextureValues(42, 0, 21, 21, BUTTON);
        this.method_37063(pick);
    }

    private void addHomeButton() {
        home = new TouhouStateSwitchButton(field_2776 + 9, field_2800 + 206, 20, 20, maid.isHomeModeEnable()) {
            @Override
            public void method_25348(double mouseX, double mouseY) {
                this.isStateTriggered = !this.isStateTriggered;
                ClientPlayNetworking.send(new MaidConfigPackage(maid.method_5628(), isStateTriggered, maid.isPickup(), maid.isRideable(), maid.getSchedule()));
            }
        };
        home.initTextureValues(0, 0, 21, 21, BUTTON);
        this.method_37063(home);
    }

    private void addDownloadButton() {
        modelDownload = new MaidDownloadButton(field_2776 + 20, field_2800 + 230, BUTTON, this.maid);
        this.method_37063(modelDownload);
    }

    private void drawTaskPageCount(class_332 graphics) {
        if (TASK_LIST_OPEN) {
            String text = String.format("%d/%d", TASK_PAGE + 1, (notHiddenTasks.size() - 1) / TASK_COUNT_PER_PAGE + 1);
            graphics.method_51433(field_22793, text, -48, 12, 0x333333, false);
        }
    }

    private void drawCurrentTaskText(class_332 graphics) {
        IMaidTask task = maid.getTask();
        graphics.method_51427(task.getIcon(), field_2776 + 6, field_2800 + 161);
        List<class_5481> splitTexts = field_22793.method_1728(task.getName(), 42);
        if (!splitTexts.isEmpty()) {
            graphics.method_51430(field_22793, splitTexts.getFirst(), field_2776 + 28, field_2800 + 165, 0x333333, false);
        }
    }

    private void renderMaidInfo(class_332 graphics, int mouseX, int mouseY) {
        if (info.method_49606()) {
            List<class_2561> list = Lists.newArrayList();
            String prefix = "§a█ ";

            class_5250 title = class_2561.method_43470("")
                    .method_10852(class_2561.method_43471("tooltips.touhou_little_maid.info.title")
                            .method_27695(class_124.field_1065, class_124.field_1073))
                    .method_10852(class_2561.method_43470("§r "));
            if (maid.isStruckByLightning()) {
                title.method_10852(class_2561.method_43470("❀").method_27692(class_124.field_1079));
            }
            if (maid.method_5655()) {
                title.method_10852(class_2561.method_43470("✟").method_27692(class_124.field_1078));
            }
            list.add(title);

            if (maid.method_35057() != null) {
                list.add(class_2561.method_43470(prefix).method_27692(class_124.field_1068)
                        .method_10852(class_2561.method_43471("tooltips.touhou_little_maid.info.owner")
                                .method_27693(": ").method_27692(class_124.field_1075))
                        .method_10852(maid.method_35057().method_5476()));
            }
            CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId()).ifPresent((info) -> list.add(class_2561.method_43470(prefix)
                    .method_27692(class_124.field_1068)
                    .method_10852(class_2561.method_43471("tooltips.touhou_little_maid.info.model_name")
                            .method_27693(": ").method_27692(class_124.field_1075))
                    .method_10852(ParseI18n.parse(info.getName()))));
            list.add(class_2561.method_43470(prefix).method_27692(class_124.field_1068)
                    .method_10852(class_2561.method_43471("tooltips.touhou_little_maid.info.experience")
                            .method_27693(": ").method_27692(class_124.field_1075))
                    .method_27693(String.valueOf(maid.getExperience())));
            list.add(class_2561.method_43470(prefix).method_27692(class_124.field_1068)
                    .method_10852(class_2561.method_43471("tooltips.touhou_little_maid.info.favorability")
                            .method_27693(": ").method_27692(class_124.field_1075))
                    .method_27693(String.valueOf(maid.getFavorability())));
            list.add(class_2561.method_43470(prefix).method_27692(class_124.field_1068)
                    .method_10852(class_2561.method_43471("block.touhou_little_maid.gomoku")
                            .method_27693(": ").method_27692(class_124.field_1075))
                    .method_10852(class_2561.method_43469("tooltips.touhou_little_maid.info.game_skill.gomoku", maid.getGameRecordManager().getGomokuWinCount(), MaidGomokuAI.getRank(maid))));

            graphics.method_51434(field_22793, list, mouseX, mouseY);
        }
    }

    private void renderScheduleInfo(class_332 graphics, int mouseX, int mouseY) {
        if (scheduleButton.method_49606()) {
            graphics.method_51434(field_22793, scheduleButton.getTooltips(), mouseX, mouseY);
        }
    }

    private void renderTaskButtonInfo(class_332 graphics, int x, int y) {
        ((ScreenAccessor) this).tlm$getRenderables().stream().filter(b -> b instanceof ITooltipButton).forEach(b -> {
            ITooltipButton tooltipButton = (ITooltipButton) b;
            if (tooltipButton.isTooltipHovered()) {
                tooltipButton.renderTooltip(graphics, Screens.getClient(this), x, y);
            }
        });
    }

    private void drawMaidCharacter(class_332 graphics, int x, int y) {
        class_490.method_2486(
                graphics,
                field_2776 + 6,
                field_2800 + 12,
                field_2776 + 73,
                field_2800 + 124,
                40,
                0.1F,
                x,
                y,
                maid);
    }

    private void drawTaskListBg(class_332 graphics) {
        if (TASK_LIST_OPEN) {
            class_768 taskListArea = getTaskListArea();
            graphics.method_25302(TASK, taskListArea.method_3321(), taskListArea.method_3322(), 0, 0, taskListArea.method_3319(), taskListArea.method_3320());
        }
    }

    @SuppressWarnings("all")
    private void drawBaseInfoGui(class_332 graphics) {
        graphics.method_51448().method_46416(0, 0, 200);
        {
            graphics.method_25302(SIDE, field_2776 + 53, field_2800 + 113, 0, 0, 9, 9);
            graphics.method_25302(SIDE, field_2776 + 5, field_2800 + 113, 0, 9, 47, 9);
            double hp = maid.method_6032() / maid.method_6063();
            graphics.method_25302(SIDE, field_2776 + 7, field_2800 + 115, 2, 18, (int) (43 * hp), 5);
            drawNumberScale(graphics, maid.method_6032(), field_2776 + 63, field_2800 + 114);
        }
        {
            graphics.method_25302(SIDE, field_2776 + 53, field_2800 + 124, 9, 0, 9, 9);
            graphics.method_25302(SIDE, field_2776 + 5, field_2800 + 124, 0, 9, 47, 9);
            double armor = Math.min(maid.method_45325(class_5134.field_23724) / 20, 1.0);
            graphics.method_25302(SIDE, field_2776 + 7, field_2800 + 126, 2, 23, (int) (43 * armor), 5);
            drawNumberScale(graphics, maid.method_6096(), field_2776 + 63, field_2800 + 125);
        }
        {
            graphics.method_25302(SIDE, field_2776 + 53, field_2800 + 135, 18, 0, 9, 9);
            graphics.method_25302(SIDE, field_2776 + 5, field_2800 + 135, 0, 9, 47, 9);

            int exp = maid.getExperience();
            int count = exp / 120;
            double percent = (exp % 120) / 120.0;
            graphics.method_25302(SIDE, field_2776 + 7, field_2800 + 137, 2, 28, (int) (43 * percent), 5);
            drawNumberScale(graphics, count, field_2776 + 63, field_2800 + 136);
        }
        {
            graphics.method_25302(SIDE, field_2776 + 53, field_2800 + 146, 27, 0, 9, 9);
            graphics.method_25302(SIDE, field_2776 + 5, field_2800 + 146, 0, 9, 47, 9);
            FavorabilityManager manager = maid.getFavorabilityManager();
            double percent = manager.getLevelPercent();
            graphics.method_25302(SIDE, field_2776 + 7, field_2800 + 148, 2, 33, (int) (43 * percent), 5);
            drawNumberScale(graphics, manager.getLevel(), field_2776 + 63, field_2800 + 147);
        }

        graphics.method_25302(SIDE, field_2776 + 94, field_2800 + 7, 107, 0, 149, 21);
        graphics.method_25302(SIDE, field_2776 + 6, field_2800 + 178, 0, 47, 67, 25);
    }

    @SuppressWarnings("all")
    private void drawNumberScale(class_332 graphics, double value, int posX, int posY) {
        String text = DECIMAL_FORMAT.format(value);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22905(0.5f, 0.5f, 1);
        graphics.method_51433(field_22793, text, posX * 2, posY * 2 + field_22793.field_2000 / 2, class_124.field_1063.method_532(), false);
        graphics.method_51448().method_22909();
    }

    @Override
    protected void method_37432() {
        counterTime += 1;
        if (counterTime % 20 == 0 && maid != null) {
            ClientPlayNetworking.send(new RequestEffectPackage(maid.method_5628()));
        }
    }

    public boolean isTaskListOpen() {
        return TASK_LIST_OPEN;
    }

    private class_768 getTaskListArea() {
        return new class_768(field_2776 - 93, field_2800 + 5, 92, 251);
    }

    // 获取女仆界面JERI屏蔽区域
    public List<class_768> getExclusionArea() {
        List<class_768> zones = new ArrayList<>();
        // 侧边栏
        zones.add(new class_768(field_2776 + 251, field_2800 + 28 + 9, 21, 99));
        // 任务列表
        if (isTaskListOpen()) {
            zones.add(getTaskListArea());
        }
        return zones;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (TASK_LIST_OPEN && getTaskListArea().method_3318((int) mouseX, (int) mouseY)) {
            if (scrollY > 0) {
                // 向上滚，相当于点击 "Page Up"
                taskPageUp();
            } else {
                // 向下滚，相当于点击 "Page Down"
                taskPageDown();
            }
            return true;
        }

        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public EntityMaid getMaid() {
        return maid;
    }

    private void renderTransTooltip(TouhouImageButton button, class_332 graphics, int x, int y, String key) {
        if (button.method_49606()) {
            graphics.method_51434(field_22793, Collections.singletonList(class_2561.method_43471(key)), x, y);
        }
    }

    private void renderTransTooltip(TouhouStateSwitchButton button, class_332 graphics, int x, int y, String key) {
        if (button.method_49606()) {
            graphics.method_51434(field_22793, Lists.newArrayList(
                    class_2561.method_43471(key + "." + button.isStateTriggered()),
                    class_2561.method_43471(key + ".desc")
            ), x, y);
        }
    }

    // 添加侧边栏按钮
    @SuppressWarnings("unchecked")
    private void addSideTabsButton() {
        MaidSideTabs<T> maidTabs = new MaidSideTabs<>(maid.method_5628(), field_2776 + 251, field_2800 + 28 + 9);
        MaidSideTabButton[] tabs = maidTabs.getTabs(this);
        for (MaidSideTabButton button : tabs) {
            this.method_37063(button);
        }
    }

    // 绘制侧边栏底部贴图
    private void drawSideTabGui(class_332 graphics, float partialTicks, int x, int y) {
        graphics.method_25302(SIDE, field_2776 + 251 + 5, field_2800 + 28 + 9, 235, 107, 21, 50);
    }
}