package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.bean.MetaData;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataPackage;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_7529;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

import static com.github.tartaricacid.touhoulittlemaid.client.event.SpecialMaidRenderEvent.EASTER_EGG_MODEL;
import static com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil.clearMaidDataResidue;

public class SettingEditScreen extends class_437 {
    private static final long MAX_TIP_TIME = 2000;

    private final EntityMaid maid;
    private final MaidAIChatManager manager;
    private class_342 ownerName;
    private class_7529 customSetting;
    private long tipTimestamp = -1;

    public SettingEditScreen(EntityMaid maid) {
        super(class_2561.method_43470("Setting Edit Screen"));
        this.maid = maid;
        this.manager = maid.getAiChatManager();
    }

    @Override
    protected void method_25426() {
        this.method_37067();

        int posX = this.field_22789 / 2 - 195;
        int boxWidth = 256;

        this.ownerName = this.method_37063(new class_342(field_22793, posX + 1, 30,
                boxWidth - 2, 20, class_2561.method_43470("Owner Name Box")));
        this.ownerName.method_1852(manager.ownerName);
        this.ownerName.method_1880(128);
        this.ownerName.method_1863(s -> manager.ownerName = s);

        this.customSetting = this.method_37063(new class_7529(field_22793,
                posX, 70, boxWidth, this.field_22790 - 100,
                class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit"),
                class_2561.method_43470("Custom Setting Box")));
        this.customSetting.method_44400(manager.customSetting);
        this.customSetting.method_44402(4096);
        this.customSetting.method_44401(s -> manager.customSetting = s);

        class_5250 export = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export");
        this.method_37063(class_4185.method_46430(export, b -> exportSetting(export))
                .method_46434(posX + 265, ownerName.method_46427(), 128, 20).method_46431());

        this.method_37063(class_4185.method_46430(class_2561.method_43471("selectWorld.edit.save"), b -> {
            this.saveConfig();
            this.tipTimestamp = System.currentTimeMillis();
        }).method_46434(posX + 265, customSetting.method_46427(), 128, 20).method_46431());

        class_5250 saveQuit = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.save_and_quit");
        this.method_37063(class_4185.method_46430(saveQuit, b -> {
            this.saveConfig();
            class_310.method_1551().method_1507(null);
        }).method_46434(posX + 265, customSetting.method_46427() + 25, 128, 20).method_46431());
    }

    private void exportSetting(class_5250 export) {
        try (MemoryStack memoryStack = MemoryStack.stackPush()) {
            String title = export.getString();
            String defaultFileName = "%s.yml".formatted(this.maid.method_5477().getString());
            String path = SettingReader.getSettingsFolder().resolve(defaultFileName).toString();
            String fileFilter = class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.format").getString();

            PointerBuffer filterPattern = memoryStack.mallocPointer(1);
            filterPattern.put(memoryStack.UTF8("*.yml"));
            filterPattern.flip();

            String result = TinyFileDialogs.tinyfd_saveFileDialog(title, path, filterPattern, fileFilter);
            if (StringUtils.isBlank(result)) {
                return;
            }

            File exportFile = new File(result);
            MetaData metaData = getMetaData();
            CharacterSetting setting = new CharacterSetting(metaData, this.customSetting.method_44405());
            setting.save(exportFile);

            if (Screens.getClient(this).field_1724 != null) {
                class_2561 tip = class_2561.method_43469("gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.export.success", result)
                        .method_27692(class_124.field_1080);
                Screens.getClient(this).field_1724.method_43496(tip);
            }
        } catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Error saving setting", e);
        }
    }

    @NotNull
    private MetaData getMetaData() {
        String lang = Screens.getClient(this).method_1526().method_4669();
        String author = "Unknown";
        if (Screens.getClient(this).field_1724 != null) {
            author = Screens.getClient(this).field_1724.method_5820();
        }
        String modelId = this.maid.getModelId();
        return new MetaData(0, author, Collections.singletonList(modelId), lang);
    }

    @Override
    public void method_25410(class_310 mc, int pWidth, int pHeight) {
        String ownerNameValue = this.ownerName.method_1882();
        String customSettingValue = this.customSetting.method_44405();
        super.method_25410(mc, pWidth, pHeight);
        this.ownerName.method_1852(ownerNameValue);
        this.customSetting.method_44400(customSettingValue);
    }

    @Override
    public boolean method_25406(double x, double y, int button) {
        return super.method_25406(x, y, button) || this.customSetting.method_25406(x, y, button);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27535(field_22793, class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.owner_name"),
                ownerName.method_46426() + 2, ownerName.method_46427() - 12, 0xFFFFFF);
        graphics.method_27535(field_22793, class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.custom_setting"),
                customSetting.method_46426() + 2, customSetting.method_46427() - 12, 0xFFFFFF);
        drawMaid(graphics, customSetting.method_46426() + customSetting.method_25368() + 73, customSetting.method_46427() + 96, maid);

        long time = System.currentTimeMillis() - this.tipTimestamp;
        if (time < MAX_TIP_TIME) {
            double value = (double) (time) / MAX_TIP_TIME * Math.PI;
            int alpha = (int) (Math.sin(value) * 0xFF);
            alpha = class_3532.method_15340(alpha, 15, 240);
            graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.saved"),
                    customSetting.method_46426() + customSetting.method_25368() + 73, customSetting.method_46427() - 12, (alpha << 24) + 0xFF1111);
        }
    }

    private void drawMaid(class_332 graphics, int posX, int posY, EntityMaid rawMaid) {
        class_1937 world = Screens.getClient(this).field_1687;
        if (world == null) {
            return;
        }
        Optional<MaidModelInfo> info = CustomPackLoader.MAID_MODELS.getInfo(rawMaid.getModelId());
        if (info.isEmpty()) {
            return;
        }
        MaidModelInfo modelInfo = info.get();

        EntityMaid maid;
        try {
            maid = (EntityMaid) EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> {
                class_1297 e = EntityMaid.TYPE.method_5883(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        } catch (ExecutionException | ClassCastException e) {
            e.fillInStackTrace();
            return;
        }

        clearMaidDataResidue(maid, false);
        if (modelInfo.getEasterEgg() != null) {
            maid.setModelId(EASTER_EGG_MODEL);
        } else {
            maid.setModelId(modelInfo.getModelId().toString());
        }
        // 女仆换皮肤界面需要指定 YSM 渲染为空
        maid.setIsYsmModel(false);
        float renderItemScale = modelInfo.getRenderItemScale();
        class_490.method_2486(
                graphics,
                posX - 45,
                posY - 45,
                posX + 45,
                posY + 55,
                (int) (45 * renderItemScale),
                0.1F,
                posX - 15,
                posY,
                maid);
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private void saveConfig() {
        ClientPlayNetworking.send(new SaveMaidAIDataPackage(this.maid.method_5628(), this.manager));
    }
}