package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.backpack;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.BaubleButton;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.TabIndex;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.BaubleContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiPackage;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;

@IPNPlayerSideOnly
@IPNGuiHint(button = IPNButton.SORT, horizontalOffset = -36, bottom = -12)
@IPNGuiHint(button = IPNButton.SORT_COLUMNS, horizontalOffset = -24, bottom = -24)
@IPNGuiHint(button = IPNButton.SORT_ROWS, horizontalOffset = -12, bottom = -36)
@IPNGuiHint(button = IPNButton.SHOW_EDITOR, horizontalOffset = -5)
@IPNGuiHint(button = IPNButton.SETTINGS, horizontalOffset = -5)
public class BaubleContainerScreen extends AbstractMaidContainerGui<BaubleContainer> implements IBackpackContainerScreen {
    private static final class_2960 BAUBLE_BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_gui_bauble.png");
    private final EntityMaid maid;
    private final int favorabilityLevel;

    public BaubleContainerScreen(BaubleContainer container, class_1661 inv, class_2561 titleIn) {
        super(container, inv, titleIn);
        this.field_2779 = 256;
        this.field_2792 = 256;
        this.maid = field_2797.getMaid();
        this.favorabilityLevel = this.maid.getFavorabilityManager().getLevel();
    }

    @Override
    protected void initAdditionWidgets() {
        BaubleButton baubleButton = new BaubleButton(field_2776, field_2800, true, btn -> {
            OpenMaidGuiPackage message = new OpenMaidGuiPackage(maid.method_5628(), TabIndex.MAIN);
            ClientPlayNetworking.send(message);
        });
        this.method_37063(baubleButton);
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_2389(graphics, partialTicks, x, y);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, BAUBLE_BG);
        graphics.method_25302(BAUBLE_BG, field_2776 + 85, field_2800 + 36, 0, 0, 165, 128);

        // 0 级和 1 级：只有前两层
        // 2 级，前四层
        // 3 级及以上，全部开放
        if (favorabilityLevel < 2) {
            graphics.method_25294(field_2776 + 152, field_2800 + 81, field_2776 + 240, field_2800 + 115, 0xaa222222);
            graphics.method_25302(BAUBLE_BG, field_2776 + 190, field_2800 + 92, 165, 0, 11, 11);
        }
        if (favorabilityLevel < 3) {
            graphics.method_25294(field_2776 + 152, field_2800 + 117, field_2776 + 240, field_2800 + 151, 0xaa222222);
            graphics.method_25302(BAUBLE_BG, field_2776 + 190, field_2800 + 127, 165, 0, 11, 11);
        }
    }

    @Override
    protected void renderAdditionTransTooltip(class_332 graphics, int x, int y) {
        if (favorabilityLevel < 2) {
            if (field_2776 + 152 <= x && x < field_2776 + 240 && field_2800 + 81 <= y && y < field_2800 + 115) {
                graphics.method_51438(field_22793, class_2561.method_43469("gui.touhou_little_maid.bauble_button.need_favorability_level", 2), x, y);
            }
        }
        if (favorabilityLevel < 3) {
            if (field_2776 + 152 <= x && x < field_2776 + 240 && field_2800 + 117 <= y && y < field_2800 + 151) {
                graphics.method_51438(field_22793, class_2561.method_43469("gui.touhou_little_maid.bauble_button.need_favorability_level", 3), x, y);
            }
        }
    }
}
