package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.HardcodedAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.ChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.*;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.patpat.PatPatCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.google.common.collect.Lists;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_9064;
import net.minecraft.class_927;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Function;

@Environment(EnvType.CLIENT)
@SuppressWarnings("rawtypes,unchecked")
public class EntityMaidRenderer extends class_927<class_1308, BedrockModel<class_1308>> {
    private static final class_2960 DEFAULT_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/empty.png");
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    /**
     * YSM 到时候会把渲染器加入其中
     */
    public static @Nullable Function<class_5617.class_5618, IGeoEntityRenderer<class_1308>> YSM_ENTITY_MAID_RENDERER;
    /**
     * 女仆模组自带的 GeckoLib 模型渲染
     */
    private final GeckoEntityMaidRenderer geckoEntityMaidRenderer;
    /**
     * YSM 借用的渲染类型，和上述互斥
     */
    private @Nullable IGeoEntityRenderer<class_1308> ysmMaidRenderer;
    private ChatBubbleRenderer chatBubbleRenderer2;
    private MaidModelInfo mainInfo;
    private List<Object> mainAnimations = Lists.newArrayList();

    public EntityMaidRenderer(class_5617.class_5618 manager) {
        super(manager, new BedrockModel<>(), 0.5f);
        this.method_4046(new LayerMaidHeldItem(this, manager.method_43338()));
        this.method_4046(new LayerMaidBipedHead(this, manager.method_32170()));
        this.method_4046(new LayerMaidBackpack(this, manager.method_32170()));
        this.method_4046(new LayerMaidBackItem(this));
        this.method_4046(new LayerMaidBanner(this, manager.method_32170()));
        this.addAdditionMaidLayer(manager);
        this.geckoEntityMaidRenderer = new GeckoEntityMaidRenderer<>(manager);
        this.initYsmModelRenderer(manager);
        this.chatBubbleRenderer2 = new ChatBubbleRenderer(this);
    }

    /**
     * 不能使用事件来初始化 YSM 渲染器
     * <p>
     * 使用事件的话，会受到先后顺序的影响
     */
    private void initYsmModelRenderer(class_5617.class_5618 manager) {
        if (!YsmCompat.isInstalled() || YSM_ENTITY_MAID_RENDERER == null) {
            return;
        }
        IGeoEntityRenderer<class_1308> geoEntityRenderer = YSM_ENTITY_MAID_RENDERER.apply(manager);
        if (geoEntityRenderer != null) {
            this.ysmMaidRenderer = geoEntityRenderer;
            // 将女仆模组自带的 GeckoLib 模型的 Layer 渲染复制到 YSM 的 Layer 里去
            List<GeoLayerRenderer> layerRenderers = this.geckoEntityMaidRenderer.getLayerRenderers();
            for (GeoLayerRenderer layerRenderer : layerRenderers) {
                this.ysmMaidRenderer.addGeoLayerRenderer(layerRenderer.copy(this.ysmMaidRenderer));
            }
        }
    }

    @Override
    public void render(class_1308 entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }

        // 卓越前线实体隐藏
        if (SWarfareCompat.shouldHideLivingRender(entity)) {
            return;
        }

        // 读取默认模型，用于清除不存在模型的缓存残留
        CustomPackLoader.MAID_MODELS.getModel(DEFAULT_MODEL_ID).ifPresent(model -> this.field_4737 = model);
        CustomPackLoader.MAID_MODELS.getInfo(DEFAULT_MODEL_ID).ifPresent(info -> this.mainInfo = info);
        CustomPackLoader.MAID_MODELS.getAnimation(DEFAULT_MODEL_ID).ifPresent(animations -> this.mainAnimations = animations);

        MaidModels.ModelData eventModelData = new MaidModels.ModelData(field_4737, mainInfo, mainAnimations);
        RenderMaidEvent event = new RenderMaidEvent(maid, eventModelData);
        RenderMaidEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled()) {
            BedrockModel<class_1308> bedrockModel = eventModelData.getModel();
            if (bedrockModel != null) {
                this.field_4737 = bedrockModel;
            }
            this.mainInfo = eventModelData.getInfo();
            this.mainAnimations = eventModelData.getAnimations();
        } else {
            // 通过模型 id 获取对应数据
            CustomPackLoader.MAID_MODELS.getModel(maid.getModelId()).ifPresent(model -> this.field_4737 = model);
            CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId()).ifPresent(info -> this.mainInfo = info);
            CustomPackLoader.MAID_MODELS.getAnimation(maid.getModelId()).ifPresent(animations -> this.mainAnimations = animations);
        }

        // 渲染聊天气泡
        EntityMaid maidEntity = maid.asStrictMaid();
        // 暂定只能女仆显示
        if (maidEntity != null && MaidConfig.GLOBAL_MAID_SHOW_CHAT_BUBBLE.get() && maidEntity.getConfigManager().isChatBubbleShow()) {
            class_243 vec3 = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_5705(partialTicks));
            if (vec3 != null) {
                poseStack.method_22903();
                double offsetY = vec3.method_10214() + 0.5f;
                if (maidEntity.isMaidInSittingPose()) {
                    offsetY -= 0.25f;
                }
                poseStack.method_22904(vec3.field_1352, offsetY, vec3.field_1350);
                poseStack.method_22907(this.field_4676.method_24197());
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180));
                poseStack.method_22905(-0.025F, -0.025F, 0.025F);
                EntityGraphics graphics = new EntityGraphics(bufferIn, poseStack, maidEntity, packedLightIn, partialTicks);
                this.chatBubbleRenderer2.render(graphics);
                poseStack.method_22909();
            }
        }

        // YSM 接管渲染
        if (maid.isYsmModel() && this.ysmMaidRenderer != null) {
            IGeoEntity geoEntity = this.ysmMaidRenderer.getGeoEntity(entity);
            geoEntity.setYsmModel(maid.getYsmModelId(), maid.getYsmModelTexture());
            if (maidEntity != null) {
                geoEntity.updateRoamingVars(maidEntity.roamingVars);
            }
            PatPatCompat.renderPat(entity, poseStack, partialTicks);
            this.ysmMaidRenderer.geoRender(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }

        // GeckoLib 接管渲染
        if (this.mainInfo.isGeckoModel()) {
            this.geckoEntityMaidRenderer.getAnimatableEntity(entity).setMaidInfo(this.mainInfo);
            PatPatCompat.renderPat(entity, poseStack, partialTicks);
            this.geckoEntityMaidRenderer.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }

        // 模型动画设置
        this.field_4737.setAnimations(this.mainAnimations);
        // 渲染女仆模型本体
        GlWrapper.setPoseStack(poseStack);
        super.method_4054(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    @Override
    protected void scale(class_1308 maid, class_4587 poseStack, float partialTickTime) {
        float scale = mainInfo.getRenderEntityScale();
        poseStack.method_22905(scale, scale, scale);
    }

    @Override
    protected void setupRotations(class_1308 mob, class_4587 poseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float pScale) {
        super.method_4058(mob, poseStack, pAgeInTicks, pRotationYaw, pPartialTicks, pScale);

        // 抱起女仆时的旋转
        if (mob.method_5854() instanceof class_1657 && !this.mainInfo.isGeckoModel()) {
            poseStack.method_22904(-0.375, 0.8325, 0.375);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(65));
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(-80));
        }

        // 其他时候的旋转
        HardcodedAnimationManger.setupRotations(mob, poseStack, pAgeInTicks, pRotationYaw, pPartialTicks, this.mainInfo.isGeckoModel());
    }

    @Override
    public class_2960 getTextureLocation(class_1308 maid) {
        if (mainInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return mainInfo.getTexture();
    }

    public MaidModelInfo getMainInfo() {
        return mainInfo;
    }

    public class_898 getDispatcher() {
        return this.field_4676;
    }

    private void addAdditionMaidLayer(class_5617.class_5618 renderManager) {
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addAdditionMaidLayer(this, renderManager);
        }
    }
}