package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class TileEntityGomokuRenderer implements class_827<TileEntityGomoku> {
    private static final class_2960 CHECKER_BOARD_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/gomoku.png");
    private static final class_2960 BLACK_PIECE_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/gomoku_black_piece.png");
    private static final class_2960 WHITE_PIECE_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/gomoku_white_piece.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final SimpleBedrockModel<class_1297> CHECKER_BOARD_MODEL;
    private final SimpleBedrockModel<class_1297> PIECE_MODEL;
    private final class_327 font;
    private final class_824 dispatcher;

    public TileEntityGomokuRenderer(class_5614.class_5615 context) {
        CHECKER_BOARD_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.GOMOKU);
        PIECE_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.GOMOKU_PIECE);
        this.font = context.method_32143();
        this.dispatcher = context.method_32139();
    }

    @Override
    public void render(TileEntityGomoku gomoku, float partialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderChessboard(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderPiece(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderLatestChessTips(gomoku, poseStack, bufferIn, combinedLightIn);
        this.renderTipsText(gomoku, poseStack, bufferIn, combinedLightIn);
    }

    private void renderLatestChessTips(TileEntityGomoku gomoku, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn) {
        if (!gomoku.getLatestChessPoint().equals(Point.NULL) && inRenderDistance(gomoku, PIECE_RENDER_DISTANCE)) {
            class_4184 camera = this.dispatcher.field_4344;
            Point point = gomoku.getLatestChessPoint();
            poseStack.method_22903();
            poseStack.method_22904(-0.42, 0.25, -0.42);
            poseStack.method_22904(point.x * 0.1316, 0, point.y * 0.1316);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180 + camera.method_19330()));
            poseStack.method_22905(0.015625F, -0.015625F, 0.015625F);
            float width = (float) (-this.font.method_1727("▼") / 2) + 0.5f;
            this.font.method_27521("▼", width, -1.5f, 0xFF0000, false, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
            poseStack.method_22909();
        }
    }

    private void renderChessboard(TileEntityGomoku gomoku, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2350 facing = gomoku.method_11010().method_11654(BlockGomoku.FACING);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(facing.method_10161() * 90));
        if (facing == class_2350.field_11035 || facing == class_2350.field_11043) {
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180));
        }
        class_4588 checkerBoardBuff = bufferIn.getBuffer(class_1921.method_23578(CHECKER_BOARD_TEXTURE));
        CHECKER_BOARD_MODEL.method_60879(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();
    }

    private void renderPiece(TileEntityGomoku gomoku, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (inRenderDistance(gomoku, PIECE_RENDER_DISTANCE)) {
            poseStack.method_22903();
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
            poseStack.method_22904(0.92, -0.1, -1.055);
            byte[][] chessData = gomoku.getChessData();
            for (byte[] row : chessData) {
                for (int j = 0; j < chessData[0].length; j++) {
                    poseStack.method_22904(0, 0, 0.1316);
                    if (row[j] == Point.BLACK) {
                        class_4588 blackPieceBuff = bufferIn.getBuffer(class_1921.method_23578(BLACK_PIECE_TEXTURE));
                        PIECE_MODEL.method_60879(poseStack, blackPieceBuff, combinedLightIn, combinedOverlayIn);
                    }
                    if (row[j] == Point.WHITE) {
                        class_4588 whitePieceBuff = bufferIn.getBuffer(class_1921.method_23578(WHITE_PIECE_TEXTURE));
                        PIECE_MODEL.method_60879(poseStack, whitePieceBuff, combinedLightIn, combinedOverlayIn);
                    }
                }
                poseStack.method_22904(-0.1316, 0, -1.974);
            }
            poseStack.method_22909();
        }
    }

    private void renderTipsText(TileEntityGomoku gomoku, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn) {
        Statue statue = gomoku.getStatue();
        if (statue != Statue.IN_PROGRESS && inRenderDistance(gomoku, TIPS_RENDER_DISTANCE)) {
            class_4184 camera = this.dispatcher.field_4344;
            class_5250 loseTips;
            class_5250 resetTips = class_2561.method_43471("message.touhou_little_maid.gomoku.reset").method_27692(class_124.field_1073).method_27692(class_124.field_1075);
            class_5250 roundText = class_2561.method_43469("message.touhou_little_maid.gomoku.round", gomoku.getChessCounter()).method_27692(class_124.field_1068);
            class_5250 preRoundIcon = class_2561.method_43470("⏹ ").method_27692(class_124.field_1060);
            class_5250 postRoundIcon = class_2561.method_43470(" ⏹").method_27692(class_124.field_1060);
            class_5250 roundTips = preRoundIcon.method_10852(roundText).method_10852(postRoundIcon);
            if (statue == Statue.WIN) {
                if (gomoku.isPlayerTurn()) {
                    loseTips = class_2561.method_43471("message.touhou_little_maid.gomoku.win").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
                } else {
                    loseTips = class_2561.method_43471("message.touhou_little_maid.gomoku.lose").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
                }
            } else {
                loseTips = class_2561.method_43471("message.touhou_little_maid.gomoku.draw").method_27692(class_124.field_1067).method_27692(class_124.field_1064);
            }
            float loseTipsWidth = (float) (-this.font.method_27525(loseTips) / 2);
            float resetTipsWidth = (float) (-this.font.method_27525(resetTips) / 2);
            float roundTipsWidth = (float) (-this.font.method_27525(roundTips) / 2);
            poseStack.method_22903();
            poseStack.method_22904(0.5, 0.75, 0.5);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(180 + camera.method_19330()));
            poseStack.method_22907(class_7833.field_40713.rotationDegrees(camera.method_19329()));
            poseStack.method_22905(0.03F, -0.03F, 0.03F);
            this.font.method_30882(loseTips, loseTipsWidth, -10, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
            poseStack.method_22905(0.5F, 0.5F, 0.5F);
            this.font.method_30882(roundTips, roundTipsWidth, -30, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
            this.font.method_30882(resetTips, resetTipsWidth, 0, 0xFFFFFF, true, poseStack.method_23760().method_23761(), bufferIn, class_327.class_6415.field_33995, 0, combinedLightIn);
            poseStack.method_22909();
        }
    }

    private boolean inRenderDistance(TileEntityGomoku gomoku, int distance) {
        class_2338 pos = gomoku.method_11016();
        return this.dispatcher.field_4344.method_19326().method_1028(pos.method_10263(), pos.method_10264(), pos.method_10260()) < distance * distance;
    }

    @Override
    public boolean shouldRenderOffScreen(TileEntityGomoku te) {
        return true;
    }

    // TODO
//    @Override
//    public AABB getRenderBoundingBox(TileEntityGomoku blockEntity) {
//        BlockPos pos = blockEntity.getBlockPos();
//        return RenderHelper.getAABB(pos.offset(-3, 0, -3), pos.offset(3, 1, 3));
//    }
}