package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_898;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

@Environment(EnvType.CLIENT)
public class TileEntityItemStackChairRenderer extends class_756 {
    public static final Supplier<TileEntityItemStackChairRenderer> INSTANCE = Suppliers.memoize(() -> {
        class_310 minecraft = class_310.method_1551();
        return new TileEntityItemStackChairRenderer(minecraft.method_31975(), minecraft.method_31974());
    });

    public TileEntityItemStackChairRenderer(class_824 dispatcher, class_5599 modelSet) {
        super(dispatcher, modelSet);
    }

    @Override
    public void method_3166(class_1799 itemStackIn, class_811 transformType, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_1937 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        EntityChair entityChair;
        ItemChair.Data data = ItemChair.getData(itemStackIn);
        float renderItemScale = CustomPackLoader.CHAIR_MODELS.getModelRenderItemScale(data.modelId());
        try {
            entityChair = (EntityChair) EntityCacheUtil.ENTITY_CACHE.get(EntityChair.TYPE, () -> {
                class_1297 e = EntityChair.TYPE.method_5883(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityChair(world));
            });
        } catch (ExecutionException | ClassCastException e) {
            e.printStackTrace();
            return;
        }
        entityChair.setModelId(data.modelId());
        poseStack.method_22903();
        poseStack.method_22905(renderItemScale, renderItemScale, renderItemScale);
        class_898 render = class_310.method_1551().method_1561();
        boolean isShowHitBox = render.method_3958();
        render.method_3955(false);
        EntityChairRenderer.renderHitBox = false;
        RenderSystem.runAsFancy(() -> render.method_3954(entityChair,
                1 / renderItemScale - 0.125, 0.25, 0.75, 0, 0,
                poseStack, buffer, combinedLight));
        EntityChairRenderer.renderHitBox = true;
        render.method_3955(isShowHitBox);
        poseStack.method_22909();
    }
}
