package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.client.render.MaidRenderState;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.item.ItemGarageKit;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_756;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_898;
import net.minecraft.class_9279;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.ENTITY_ID_TAG_NAME;
import static com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil.clearMaidDataResidue;

public class TileEntityItemStackGarageKitRenderer extends class_756 {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/block/statue_base.png");
    private static SimpleBedrockModel<class_1297> BASE_MODEL;

    public static final Supplier<TileEntityItemStackGarageKitRenderer> INSTANCE = Suppliers.memoize(() -> {
        class_310 minecraft = class_310.method_1551();
        return new TileEntityItemStackGarageKitRenderer(minecraft.method_31975(), minecraft.method_31974());
    });

    public TileEntityItemStackGarageKitRenderer(class_824 dispatcher, class_5599 modelSet) {
        super(dispatcher, modelSet);
        BASE_MODEL = BedrockModelLoader.getModel(BedrockModelLoader.STATUE_BASE);
    }

    @Override
    public void method_3166(class_1799 stack, class_811 transformType, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (BASE_MODEL == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22904(1, 1.5, 1);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
        class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
        BASE_MODEL.method_60879(poseStack, buffer, combinedLightIn, combinedOverlayIn);
        poseStack.method_22909();

        class_9279 data = ItemGarageKit.getMaidData(stack);
        class_1937 world = class_310.method_1551().field_1687;
        if (data.method_57458() || world == null) {
            return;
        }

        class_1299.method_5898(data.method_57446(Codec.STRING.fieldOf(ENTITY_ID_TAG_NAME)).getOrThrow()).ifPresent(type -> {
                    try {
                        renderEntity(stack, poseStack, bufferIn, combinedLightIn, data.method_57461(), world, type);
                    } catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
        );
    }

    private void renderEntity(class_1799 stack, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, class_2487 data, class_1937 world, class_1299<?> type) throws ExecutionException {
        class_1297 entity;
        if (type.equals(InitEntities.MAID)) {
            entity = EntityCacheUtil.GARAGE_KIT_CACHE.get(stack, () -> new EntityMaid(world));
        } else {
            entity = EntityCacheUtil.ENTITY_CACHE.get(type, () -> {
                class_1297 e = type.method_5883(world);
                return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
            });
        }

        float renderItemScale = 1;
        entity.method_5651(data);
        if (entity instanceof EntityMaid maid) {
            clearMaidDataResidue(maid, true);
            if (data.method_10573(EntityMaid.MODEL_ID_TAG, class_2520.field_33258)) {
                String modelId = data.method_10558(EntityMaid.MODEL_ID_TAG);
                renderItemScale = CustomPackLoader.MAID_MODELS.getModelRenderItemScale(modelId);
            }
            maid.renderState = MaidRenderState.GARAGE_KIT;
        }

        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        poseStack.method_22905(renderItemScale, renderItemScale, renderItemScale);
        poseStack.method_22904(1, 0.21328125, 1);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180));
        class_898 render = class_310.method_1551().method_1561();
        boolean isShowHitBox = render.method_3958();
        render.method_3955(false);
        RenderSystem.runAsFancy(() -> {
            render.method_3954(entity, 0, 0, 0, 0, 0,
                    poseStack, bufferIn, combinedLightIn);
        });
        render.method_3955(isShowHitBox);
        poseStack.method_22909();
    }
}