package com.github.tartaricacid.touhoulittlemaid.compat.emi.altar;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.emi.MaidEmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;

public class EmiAltarRecipe implements EmiRecipe {
    private static final EmiTexture POWER_ICON = new EmiTexture(class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/power_point.png"), 32, 0, 16, 16, 16, 16, 64, 64);
    private final class_2960 id;
    private final List<EmiStack> outputs;
    private final List<EmiIngredient> inputs;
    private final float powerCost;
    private final String langKey;

    public EmiAltarRecipe(class_2960 id, List<EmiIngredient> inputs, List<EmiStack> outputs, float powerCost, String langKey) {
        this.id = id;
        this.inputs = inputs;
        this.outputs = outputs;
        this.powerCost = powerCost;
        this.langKey = langKey;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return MaidEmiPlugin.ALTAR;
    }

    @Override
    public @Nullable class_2960 getId() {
        return id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return inputs;
    }

    @Override
    public List<EmiStack> getOutputs() {
        return outputs;
    }

    @Override
    public int getDisplayWidth() {
        return 160;
    }

    @Override
    public int getDisplayHeight() {
        return 125;
    }

    @Override
    public boolean supportsRecipeTree() {
        return true;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        int darkGray = 0x555555;
        class_327 font = class_310.method_1551().field_1772;
        String result = class_1074.method_4662("jei.touhou_little_maid.altar_craft.result", class_1074.method_4662(this.langKey));

        widgets.addSlot(getInput(inputs, 0), 40, 35);
        widgets.addSlot(getInput(inputs, 1), 40, 55);
        widgets.addSlot(getInput(inputs, 2), 60, 15);
        widgets.addSlot(getInput(inputs, 3), 80, 15);
        widgets.addSlot(getInput(inputs, 4), 100, 35);
        widgets.addSlot(getInput(inputs, 5), 100, 55);
        widgets.addSlot(outputs.getFirst(), 140, 5);

        widgets.addTexture(POWER_ICON, 72, 38);
        widgets.addText(class_2561.method_43470(result), (int) ((widgets.getWidth() - font.method_1727(result)) / 2.0f), 85, darkGray, false);
        widgets.addText(class_2561.method_43470(String.format("×%.2f", powerCost)), 65, 55, darkGray, false);
    }

    private EmiIngredient getInput(List<EmiIngredient> inputs, int index) {
        if (index < inputs.size()) {
            return inputs.get(index);
        }
        return EmiStack.EMPTY;
    }
}