package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class TaskGunAttack implements IRangedAttackTask {
    public static final class_2960 UID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "gun_attack");
    private static class_1799 ICON;

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        if (ICON == null) {
            ICON = InitItems.TACZ_GUN_ICON.method_7854();
        }
        return ICON;
    }

    @Nullable
    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(
                this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138(target ->
                !this.mainhandHoldGun(maid) || farAway(target, maid));
        class_7893<EntityMaid> gunWalkTargetTask = MaidRangedWalkToTarget.create(0.6f);
        class_7893<EntityMaid> gunAttackStrafingTask = new GunAttackStrafingTask();
        class_7893<EntityMaid> gunShootTargetTask = new GunShootTargetTask();
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, gunWalkTargetTask),
                Pair.of(5, gunAttackStrafingTask),
                Pair.of(5, gunShootTargetTask),
                Pair.of(5, maidUseShieldTask)
        );
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        // 因为骑乘载具时，也会有射击，故此处设定敌对目标使用 canStartAttacking 方法
        class_7893<EntityMaid> supplementedTask = class_4824.method_47120(
                GunCommonUtil::canStartAttacking, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893<EntityMaid> findTargetTask = class_4828.method_47138(target ->
                !GunCommonUtil.canStartAttacking(maid) || farAway(target, maid));
        class_7893<EntityMaid> gunShootTargetTask = new GunShootTargetTask();

        return Lists.newArrayList(
                Pair.of(5, supplementedTask),
                Pair.of(5, findTargetTask),
                Pair.of(5, gunShootTargetTask)
        );
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (GunCommonUtil.canStartAttacking(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014(searchRange);
            } else {
                return maid.method_5829().method_1014(searchRange);
            }
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return MaidConfig.MAID_GUN_LONG_DISTANCE.get();
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return GunCommonUtil.canSee(maid, target)
                .orElseGet(() -> IRangedAttackTask.super.canSee(maid, target));
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of("has_gun", m -> isWeapon(m, m.method_6047())));
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return GunCommonUtil.isGun(stack);
    }

    private boolean mainhandHoldGun(EntityMaid maid) {
        class_1799 item = maid.method_6047();
        return isWeapon(maid, item);
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739(target) > this.searchRadius(maid);
    }

    /**
     * 枪械射击不走原版那套逻辑，故此方法为空
     */
    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
    }
}