package com.github.tartaricacid.touhoulittlemaid.compat.patchouli;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public class AltarRecipeComponent implements IComponentProcessor {
    private static final String RECIPE_ID = "recipe_id";
    private static final String INPUT = "input";
    private static final String POWER_COST = "power_cost";
    private static final String OUTPUT_ITEM = "output_item";
    private static final String OUTPUT_ENTITY = "output_entity";
    private static final String OUTPUT_DESC = "output_desc";

    private @Nullable AltarRecipe recipe;

    @SuppressWarnings("all")
    @Override
    public void setup(class_1937 level, IVariableProvider variables) {
        class_2960 recipeId = class_2960.method_60654(variables.get(RECIPE_ID, level.method_30349()).asString());
        List<class_8786<AltarRecipe>> allAltarRecipes = level.method_8433().method_30027(InitRecipes.ALTAR_CRAFTING);
        for (class_8786<AltarRecipe> recipe : allAltarRecipes) {
            if (recipe.comp_1932().equals(recipeId)) {
                this.recipe = recipe.comp_1933();
                return;
            }
        }
        this.recipe = new AltarRecipe("altar_recipe", class_7710.field_40251, class_2371.method_10212(class_1856.field_9017),
                0, class_1799.field_8037, class_2960.method_60656("item"), "");
        TouhouLittleMaid.LOGGER.error("Altar recipe not found: {}", recipeId);
    }

    @Nullable
    @Override
    public IVariable process(class_1937 level, String key) {
        if (key.startsWith(INPUT)) {
            int index = Integer.parseInt(key.substring(INPUT.length())) - 1;
            if (index < 0 || index >= recipe.method_8117().size()) {
                return IVariable.from(class_1799.field_8037, level.method_30349());
            }
            class_1856 ingredient = recipe.method_8117().get(index);
            class_1799[] stacks = ingredient.method_8105();
            if (stacks.length == 0) {
                return IVariable.from(class_1799.field_8037, level.method_30349());
            }
            List<String> stackNames = Lists.newArrayList();
            for (class_1799 stack : stacks) {
                class_2960 itemId = class_7923.field_41178.method_10221(stack.method_7909());
                stackNames.add(itemId.toString());
            }
            return IVariable.wrap(StringUtils.join(stackNames, ","), level.method_30349());
        }

        switch (key) {
            case POWER_COST -> {
                float powerCost = recipe.getPower();
                return IVariable.wrap(String.format("x%.2f", powerCost), level.method_30349());
            }
            case OUTPUT_ITEM -> {
                if (!recipe.isItemCraft()) {
                    return IVariable.from(class_1799.field_8037, level.method_30349());
                }
                return IVariable.from(recipe.method_8110(level.method_30349()), level.method_30349());
            }
            case OUTPUT_DESC -> {
                return IVariable.wrap(class_1074.method_4662(recipe.getLangKey()), level.method_30349());
            }
            case OUTPUT_ENTITY -> {
                String entityId = recipe.getEntityType().toString();
                // 特判，女仆生成是实体对象是盒子，这里纠正为女仆
                if ("touhou_little_maid:box".equals(entityId)) {
                    entityId = "touhou_little_maid:maid";
                }
                return IVariable.wrap(entityId, level.method_30349());
            }
        }

        return null;
    }
}
