package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class AltarRecipeSerializer implements class_1865<AltarRecipe> {
    public static final MapCodec<AltarRecipe> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                    Codec.STRING.optionalFieldOf("group", StringUtils.EMPTY).forGetter(AltarRecipe::method_8112),
                    class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(AltarRecipe::getCategory),
                    class_1856.field_46095.listOf().fieldOf("ingredients").flatXmap(AltarRecipeSerializer::checkIngredients, DataResult::success).forGetter(AltarRecipe::method_8117),
                    Codec.FLOAT.fieldOf("power").forGetter(AltarRecipe::getPower),
                    class_1799.field_51397.fieldOf("result").forGetter(AltarRecipe::getResult),
                    class_2960.field_25139.fieldOf("entity").forGetter(AltarRecipe::getEntityType),
                    Codec.STRING.optionalFieldOf("lang", StringUtils.EMPTY).forGetter(AltarRecipe::getLangKey)
            ).apply(instance, AltarRecipe::new)
    );

    @NotNull
    private static DataResult<class_2371<class_1856>> checkIngredients(List<class_1856> ingredientList) {
        class_1856[] aingredient = ingredientList.toArray(class_1856[]::new);
        if (aingredient.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        } else {
            if (aingredient.length > 6) {
                return DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: 6");
            }
            return DataResult.success(class_2371.method_10212(class_1856.field_9017, aingredient));
        }
    }

    private AltarRecipe fromNetwork(class_9129 byteBuf) {
        String group = byteBuf.method_19772();
        class_7710 category = byteBuf.method_10818(class_7710.class);
        class_2371<class_1856> ingredients = class_2371.method_10213(byteBuf.method_10816(), class_1856.field_9017);
        ingredients.replaceAll((ingredient) -> class_1856.field_48355.decode(byteBuf));
        float power = byteBuf.readFloat();
        class_1799 result = class_1799.field_48349.decode(byteBuf);
        class_2960 entityType = byteBuf.method_10810();
        String langKey = byteBuf.method_19772();
        return new AltarRecipe(group, category, ingredients, power, result, entityType, langKey);
    }

    private void toNetwork(class_9129 friendlyByteBuf, AltarRecipe altarRecipe) {
        friendlyByteBuf.method_10814(altarRecipe.method_8112());
        friendlyByteBuf.method_10817(altarRecipe.getCategory());
        friendlyByteBuf.method_10804(altarRecipe.method_8117().size());
        for (class_1856 ingredient : altarRecipe.method_8117()) {
            class_1856.field_48355.encode(friendlyByteBuf, ingredient);
        }
        friendlyByteBuf.method_52941(altarRecipe.getPower());
        class_1799.field_48349.encode(friendlyByteBuf, altarRecipe.getResult());
        friendlyByteBuf.method_10812(altarRecipe.getEntityType());
        friendlyByteBuf.method_10814(altarRecipe.getLangKey());
    }

    @Override
    public MapCodec<AltarRecipe> method_53736() {
        return CODEC;
    }

    @Override
    public class_9139<class_9129, AltarRecipe> method_56104() {
        return class_9139.method_56437(this::toNetwork, this::fromNetwork);
    }
}
