package com.github.tartaricacid.touhoulittlemaid.datagen;

import cn.sh1rocu.touhoulittlemaid.util.recipe.ItemStackShapelessRecipeBuilder;
import com.github.tartaricacid.touhoulittlemaid.datagen.builder.AltarRecipeBuilder;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.registry.CompatRegistry;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import vazkii.patchouli.common.item.PatchouliDataComponents;
import vazkii.patchouli.common.item.PatchouliItems;

import java.util.concurrent.CompletableFuture;

public class RecipeGenerator extends FabricRecipeProvider {
    public RecipeGenerator(FabricDataOutput pOutput, CompletableFuture<class_7225.class_7874> pRegistries) {
        super(pOutput, pRegistries);
    }


    @SuppressWarnings("all")
    @Override
    public void method_10419(class_8790 recipeOutput) {
        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.BOOKSHELF)
                .power(0.1F)
                .requires(4, class_3489.field_15537)
                .requires(class_1802.field_8529)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.BROOM)
                .power(0.2F)
                .requires(3, class_1802.field_17528)
                .requires(2, ConventionalItemTags.WOODEN_RODS)
                .requires(class_1802.field_8449)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.CAMERA)
                .power(0.2F)
                .requires(4, class_1802.field_20402)
                .requires(2, ConventionalItemTags.OBSIDIANS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.CHISEL)
                .power(0.2F)
                .requires(2, ConventionalItemTags.WOODEN_RODS)
                .requires(2, ConventionalItemTags.IRON_INGOTS)
                .requires(ConventionalItemTags.YELLOW_DYES)
                .requires(ConventionalItemTags.RED_DYES)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.COMPUTER)
                .power(0.1F)
                .requires(3, class_3489.field_15537)
                .requires(class_1802.field_8643)
                .requires(class_1802.field_8865)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.CRAFTING_TABLE_BACKPACK)
                .power(0.2F)
                .requires(InitItems.MAID_BACKPACK_MIDDLE)
                .requires(ConventionalItemTags.PLAYER_WORKSTATIONS_CRAFTING_TABLES)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.DROWN_PROTECT_BAUBLE)
                .power(0.2F)
                .requires(ConventionalItemTags.NETHER_WART_CROPS)
                .requires(ConventionalItemTags.LIME_DYES)
                .requires(4, class_3489.field_15527)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.ENDER_CHEST_BACKPACK)
                .power(0.2F)
                .requires(InitItems.MAID_BACKPACK_MIDDLE)
                .requires(class_1802.field_8466)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.EXPLOSION_PROTECT_BAUBLE)
                .power(0.2F)
                .requires(ConventionalItemTags.NETHER_WART_CROPS)
                .requires(ConventionalItemTags.ORANGE_DYES)
                .requires(4, ConventionalItemTags.OBSIDIANS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.EXTINGUISHER)
                .power(0.2F)
                .requires(4, class_1802.field_8696)
                .requires(ConventionalItemTags.ORANGE_DYES)
                .requires(ConventionalItemTags.RED_DYES)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.FALL_PROTECT_BAUBLE)
                .power(0.2F)
                .requires(ConventionalItemTags.NETHER_WART_CROPS)
                .requires(ConventionalItemTags.YELLOW_DYES)
                .requires(4, ConventionalItemTags.FEATHERS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.FIRE_PROTECT_BAUBLE)
                .power(0.2F)
                .requires(ConventionalItemTags.NETHER_WART_CROPS)
                .requires(ConventionalItemTags.RED_DYES)
                .requires(4, class_1802.field_8183)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.FURNACE_BACKPACK)
                .power(0.2F)
                .requires(InitItems.MAID_BACKPACK_MIDDLE)
                .requires(ConventionalItemTags.PLAYER_WORKSTATIONS_FURNACES)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.GOMOKU)
                .power(0.1F)
                .requires(3, class_3489.field_15537)
                .requires(ConventionalItemTags.BLACK_DYES)
                .requires(ConventionalItemTags.WHITE_DYES)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.CCHESS)
                .power(0.1F)
                .requires(3, class_3489.field_15537)
                .requires(ConventionalItemTags.BLACK_DYES)
                .requires(ConventionalItemTags.RED_DYES)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.WCHESS)
                .power(0.1F)
                .requires(3, class_3489.field_15537)
                .requires(ConventionalItemTags.BLACK_DYES)
                .requires(ConventionalItemTags.WHITE_DYES)
                .requires(ConventionalItemTags.EMERALD_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.HAKUREI_GOHEI)
                .power(0.15F)
                .requires(3, ConventionalItemTags.WOODEN_RODS)
                .requires(3, class_1802.field_8407)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.ITEM_MAGNET_BAUBLE)
                .power(0.2F)
                .requires(3, ConventionalItemTags.REDSTONE_DUSTS)
                .requires(3, ConventionalItemTags.IRON_INGOTS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.KAPPA_COMPASS)
                .power(0.1F)
                .requires(3, ConventionalItemTags.OBSIDIANS)
                .requires(ConventionalItemTags.CYAN_DYES)
                .requires(2, ConventionalItemTags.REDSTONE_DUSTS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.KEYBOARD)
                .power(0.1F)
                .requires(4, class_3489.field_15537)
                .requires(class_1802.field_8643)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MAGIC_PROTECT_BAUBLE)
                .power(0.2F)
                .requires(ConventionalItemTags.NETHER_WART_CROPS)
                .requires(ConventionalItemTags.CYAN_DYES)
                .requires(4, class_1802.field_8479)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MAID_BACKPACK_BIG)
                .power(0.3F)
                .requires(4, class_1802.field_19051)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .requires(class_1802.field_19051)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MAID_BACKPACK_MIDDLE)
                .power(0.2F)
                .requires(4, class_1802.field_19050)
                .requires(ConventionalItemTags.GOLD_INGOTS)
                .requires(class_1802.field_19050)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MAID_BACKPACK_SMALL)
                .power(0.1F)
                .requires(4, class_1802.field_19058)
                .requires(ConventionalItemTags.IRON_INGOTS)
                .requires(class_1802.field_19058)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MAID_BEACON)
                .power(0.2F)
                .requires(class_3489.field_15537)
                .requires(ConventionalItemTags.RED_DYES)
                .requires(class_3489.field_15537)
                .requires(ConventionalItemTags.OBSIDIANS)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .requires(ConventionalItemTags.OBSIDIANS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MAID_BED)
                .power(0.2F)
                .requires(class_1802.field_19050)
                .requires(class_3489.field_15537)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.MUTE_BAUBLE)
                .power(0.2F)
                .requires(class_3489.field_15544)
                .requires(class_1802.field_8696)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.NIMBLE_FABRIC)
                .power(0.2F)
                .requires(ConventionalItemTags.ENDER_PEARLS)
                .requires(class_3489.field_15544)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.PICNIC_BASKET)
                .power(0.2F)
                .requires(ConventionalItemTags.WOODEN_CHESTS)
                .requires(4, class_1802.field_8648)
                .requires(class_3489.field_15542)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.PROJECTILE_PROTECT_BAUBLE)
                .power(0.2F)
                .requires(ConventionalItemTags.NETHER_WART_CROPS)
                .requires(ConventionalItemTags.BLUE_DYES)
                .requires(4, class_1802.field_8255)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.RED_FOX_SCROLL)
                .power(0.1F)
                .requires(4, class_1802.field_8407)
                .requires(ConventionalItemTags.RED_DYES)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.SANAE_GOHEI)
                .power(0.15F)
                .requires(4, ConventionalItemTags.WOODEN_RODS)
                .requires(2, class_1802.field_8407)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.SCARECROW)
                .power(0.2F)
                .requires(2, class_1802.field_17528)
                .requires(2, class_1802.field_20394)
                .requires(2, ConventionalItemTags.REDSTONE_DUSTS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.TANK_BACKPACK)
                .power(0.2F)
                .requires(InitItems.MAID_BACKPACK_MIDDLE)
                .requires(class_1802.field_8550)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.TRUMPET)
                .power(0.2F)
                .requires(2, ConventionalItemTags.GOLD_INGOTS)
                .requires(3, ConventionalItemTags.IRON_INGOTS)
                .requires(class_1802.field_8643)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.ULTRAMARINE_ORB_ELIXIR)
                .power(0.3F)
                .requires(ConventionalItemTags.EMERALD_GEMS)
                .requires(ConventionalItemTags.ENDER_PEARLS)
                .requires(4, ConventionalItemTags.CYAN_DYES)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.WHITE_FOX_SCROLL)
                .power(0.1F)
                .requires(4, class_1802.field_8407)
                .requires(ConventionalItemTags.WHITE_DYES)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.WIRELESS_IO)
                .power(0.2F)
                .requires(ConventionalItemTags.ENDER_PEARLS)
                .requires(ConventionalItemTags.WOODEN_CHESTS)
                .requires(class_1802.field_8239)
                .method_10431(recipeOutput);

        AltarRecipeBuilder.shapeless(class_7800.field_40642, InitItems.SERVANT_BELL)
                .power(0.2F)
                .requires(2, ConventionalItemTags.GOLD_INGOTS)
                .requires(2, ConventionalItemTags.GOLD_NUGGETS)
                .requires(2, ConventionalItemTags.WOODEN_RODS)
                .method_10431(recipeOutput);

        class_1799 entityPlaceholder = new class_1799(InitItems.ENTITY_PLACEHOLDER);
        entityPlaceholder.method_57379(InitDataComponent.RECIPES_ID_TAG, "reborn_maid");
        AltarRecipeBuilder.shapeless(class_7800.field_40642, entityPlaceholder)
                .power(0.5F)
                .requires(InitItems.FILM)
                .requires(ConventionalItemTags.LAPIS_GEMS)
                .requires(ConventionalItemTags.GOLD_INGOTS)
                .requires(ConventionalItemTags.REDSTONE_DUSTS)
                .requires(ConventionalItemTags.IRON_INGOTS)
                .requires(class_1802.field_8713)
                .entity(class_1299.method_5890(InitEntities.MAID))
                .langKey("jei.touhou_little_maid.altar_craft.reborn_maid.result")
                .method_36443(recipeOutput, "reborn_maid");

        entityPlaceholder.method_57379(InitDataComponent.RECIPES_ID_TAG, "spawn_box");
        AltarRecipeBuilder.shapeless(class_7800.field_40642, entityPlaceholder)
                .power(0.5F)
                .requires(ConventionalItemTags.DIAMOND_GEMS)
                .requires(ConventionalItemTags.LAPIS_GEMS)
                .requires(ConventionalItemTags.GOLD_INGOTS)
                .requires(ConventionalItemTags.REDSTONE_DUSTS)
                .requires(ConventionalItemTags.IRON_INGOTS)
                .requires(class_1802.field_8713)
                .entity(class_1299.method_5890(InitEntities.BOX))
                .langKey("jei.touhou_little_maid.altar_craft.spawn_box.result")
                .method_36443(recipeOutput, "spawn_box");

        entityPlaceholder.method_57379(InitDataComponent.RECIPES_ID_TAG, "spawn_lightning_bolt");
        AltarRecipeBuilder.shapeless(class_7800.field_40642, entityPlaceholder)
                .power(0.2F)
                .requires(3, ConventionalItemTags.GUNPOWDERS)
                .requires(3, class_1802.field_8183)
                .entity(class_1299.method_5890(class_1299.field_6112))
                .langKey("jei.touhou_little_maid.altar_craft.spawn_lightning_bolt.result")
                .method_36443(recipeOutput, "spawn_lightning_bolt");

        class_2447.method_10437(class_7800.field_40642, InitItems.HAKUREI_GOHEI)
                .method_10439("  D")
                .method_10439(" SP")
                .method_10439("S P")
                .method_10433('S', ConventionalItemTags.WOODEN_RODS)
                .method_10433('D', ConventionalItemTags.DIAMOND_GEMS)
                .method_10434('P', class_1802.field_8407)
                .method_10429(method_32807(class_1802.field_8477), method_10420(ConventionalItemTags.DIAMOND_GEMS))
                .method_10431(recipeOutput);

        class_2447.method_10437(class_7800.field_40642, InitItems.SANAE_GOHEI)
                .method_10439(" PD")
                .method_10439(" SP")
                .method_10439("S  ")
                .method_10433('S', ConventionalItemTags.WOODEN_RODS)
                .method_10433('D', ConventionalItemTags.DIAMOND_GEMS)
                .method_10434('P', class_1802.field_8407)
                .method_10429(method_32807(class_1802.field_8477), method_10420(ConventionalItemTags.DIAMOND_GEMS))
                .method_10431(recipeOutput);


        ResourceCondition modLoadedCondition = ResourceConditions.allModsLoaded(CompatRegistry.PATCHOULI);
        class_1799 patchouliBook = new class_1799(PatchouliItems.BOOK);
        patchouliBook.method_57379(PatchouliDataComponents.BOOK, InitItems.MEMORIZABLE_GENSOKYO_LOCATION);
        ItemStackShapelessRecipeBuilder.shapeless(class_7800.field_40642, patchouliBook)
                .requires(ConventionalItemTags.WHITE_DYES)
                .requires(ConventionalItemTags.RED_DYES)
                .requires(class_1802.field_8529)
                .method_33530(method_32807(class_1802.field_8529), method_10426(class_1802.field_8529))
                .method_17972(withConditions(recipeOutput, modLoadedCondition), InitItems.MEMORIZABLE_GENSOKYO_LOCATION);

        class_2447.method_10437(class_7800.field_40642, InitItems.CHAIR)
                .method_10439("   ")
                .method_10439("WWW")
                .method_10439("IPI")
                .method_10433('W', class_3489.field_15544)
                .method_10433('I', ConventionalItemTags.IRON_INGOTS)
                .method_10433('P', class_3489.field_15537)
                .method_10429("has_wool", method_10420(class_3489.field_15544))
                .method_10431(recipeOutput);

        class_2447.method_10437(class_7800.field_40642, InitItems.CHAIR_SHOW)
                .method_10439(" R ")
                .method_10439("WWW")
                .method_10439("IPI")
                .method_10433('W', class_3489.field_15544)
                .method_10433('I', ConventionalItemTags.IRON_INGOTS)
                .method_10433('P', class_3489.field_15537)
                .method_10433('R', ConventionalItemTags.REDSTONE_DUSTS)
                .method_10429(method_32807(class_1802.field_8725), method_10420(ConventionalItemTags.REDSTONE_DUSTS))
                .method_10431(recipeOutput);

        class_2450.method_10447(class_7800.field_40642, InitItems.ENTITY_ID_COPY)
                .method_10446(ConventionalItemTags.LEATHERS)
                .method_10454(class_1802.field_8407)
                .method_10442(method_32807(class_1802.field_8529), method_10426(class_1802.field_8529))
                .method_10431(recipeOutput);
    }
}
