package com.github.tartaricacid.touhoulittlemaid.datapack.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7367;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;

public class BoardStateDataReloadListener implements class_4013, IdentifiableResourceReloadListener {
    private static final class_2960 CHESS_PATH = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "board_states/chess.json");
    private static final class_2960 XIANGQI_PATH = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "board_states/xiangqi.json");
    private static final class_2960 GOMOKU_PATH = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "board_states/gomoku.json");

    private static final Gson GSON = new Gson();

    public static final class_2960 ID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "board_states_reload");

    @Override
    public void method_14491(class_3300 resourceManager) {
        // 先清除旧数据
        BoardStateData.clear();
        // 再逐层读取新数据，进行合并加载
        resourceManager.method_29213().forEach(packResources -> {
            readData(packResources, CHESS_PATH, BoardStateData::addChessRecords);
            readData(packResources, XIANGQI_PATH, BoardStateData::addXiangqiRecords);
            readData(packResources, GOMOKU_PATH, BoardStateData::addGomokuRecords);
        });
    }

    private static void readData(class_3262 packResources, class_2960 path, Consumer<List<BoardStateRecord>> adder) {
        class_7367<InputStream> resource = packResources.method_14405(class_3264.field_14190, path);
        if (resource == null) {
            return;
        }
        try (InputStream inputStream = resource.get(); InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8)) {
            List<BoardStateRecord> records = GSON.fromJson(reader, new TypeToken<List<BoardStateRecord>>() {
            }.getType());
            if (records != null && !records.isEmpty()) {
                adder.accept(records);
            }
        } catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to load board state data from {}", path, e);
        }
    }

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}