package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.OptionalBox;
import org.jetbrains.annotations.NotNull;

import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_4102;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_6670;
import net.minecraft.class_7893;
import net.minecraft.class_7898;
import net.minecraft.class_7906;
import net.minecraft.class_7911;

/**
 * 修改了原版的走向攻击目标的 AI，现在能够依据超远视距和 home 范围进行行走判断
 * <p>
 * 主要用于远程射击，近战的还是请走 SetWalkTargetFromAttackTargetIfTargetOutOfReach
 */
public class MaidRangedWalkToTarget {
    public static class_7893<EntityMaid> create(float speedModifier) {
        return create(entity -> speedModifier);
    }

    public static class_7893<EntityMaid> create(Function<class_1309, Float> speedModifier) {
        return class_7898.method_47224(maidInstance -> maidInstance.group(
                        maidInstance.method_47235(class_4140.field_18445),
                        maidInstance.method_47235(class_4140.field_18446),
                        maidInstance.method_47244(class_4140.field_22355),
                        maidInstance.method_47235(class_4140.field_18442))
                .apply(maidInstance, (walkTargetMemory, positionMemory, entityMemory, livingEntitiesMemory)
                        -> setTarget(speedModifier, maidInstance, walkTargetMemory, positionMemory, entityMemory, livingEntitiesMemory)));
    }

    @NotNull
    private static class_7911<EntityMaid> setTarget(Function<class_1309, Float> speedModifier,
                                                 class_7898.class_7900<EntityMaid> maidInstance,
                                                 class_7906<OptionalBox.Mu, class_4142> walkTargetMemory,
                                                 class_7906<OptionalBox.Mu, class_4115> positionMemory,
                                                 class_7906<IdF.Mu, class_1309> entityMemory,
                                                 class_7906<OptionalBox.Mu, class_6670> livingEntitiesMemory) {
        return (level, maid, gameTime) -> {
            class_1309 target = maidInstance.method_47243(entityMemory);
            if (maid.canSee(target) && shouldEraseWalkTarget(maid, target)) {
                walkTargetMemory.method_47252();
            } else {
                positionMemory.method_47249(new class_4102(target, true));
                walkTargetMemory.method_47249(new class_4142(new class_4102(target, false), speedModifier.apply(maid), 0));
            }
            return true;
        };
    }

    private static boolean shouldEraseWalkTarget(EntityMaid maid, class_1309 target) {
        float restrictRadius = maid.method_18413() - 2;
        double checkRadius = 8;
        if (maid.method_18410()) {
            class_2338 center = maid.method_18412();
            checkRadius = Math.sqrt(target.method_5649(center.method_10263(), center.method_10264(), center.method_10260()));
        } else if (maid.method_35057() instanceof class_1657 player) {
            checkRadius = target.method_5739(player);
        }
        // 如果目标在 4 格外，在 最大限制范围-2 内，可以直接走过去，否则清除目标
        return checkRadius <= 4 || checkRadius >= restrictRadius;
    }
}
