package com.github.tartaricacid.touhoulittlemaid.entity.ai.path;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugMaidManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import net.minecraft.class_11;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_3695;
import net.minecraft.class_4459;
import net.minecraft.class_5;
import net.minecraft.class_8;
import net.minecraft.class_9;
import net.minecraft.world.level.pathfinder.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用于加入debug信息
 */
public class MaidWrappedPathFinder extends class_13 {
    protected class_1308 mob;

    public MaidWrappedPathFinder(class_8 nodeEvaluator, int maxVisitedNodes) {
        super(nodeEvaluator, maxVisitedNodes);
    }

    @Nullable
    @Override
    public class_11 method_52(@NotNull class_1950 region, @NotNull class_1308 mob, @NotNull Set<class_2338> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.mob = mob;
        return super.method_52(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
    }

    @Nullable
    @Override
    public class_11 method_54(@NotNull class_3695 profiler, @NotNull class_9 node, @NotNull Map<class_4459, class_2338> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        if (TouhouLittleMaid.DEBUG && mob instanceof EntityMaid maid && DebugMaidManager.getDebuggingPlayer(maid) != null) {
            List<class_9> tmpClosedSet = Lists.newArrayList();
            this.field_62 = new class_5() {
                @Override
                public @NotNull class_9 method_6() {
                    class_9 pop = super.method_6();
                    tmpClosedSet.add(pop);
                    return pop;
                }
            };
            class_11 path = super.method_54(profiler, node, targetPos, maxRange, accuracy, searchDepthMultiplier);
            if (path == null) {
                return null;
            }
            // 因为上面 wrap 了一手 pop，所以下面的代码会导致 close 的大小发生变化，需要先处理
            class_9[] closedSet = tmpClosedSet.toArray(new class_9[0]);

            class_9[] openSet = new class_9[this.field_62.method_35492()];
            int idx = 0;
            while (!this.field_62.method_8()) {
                openSet[idx++] = this.field_62.method_6();
            }
            path.method_35500(openSet, closedSet, targetPos.keySet());
            return path;
        }
        return super.method_54(profiler, node, targetPos, maxRange, accuracy, searchDepthMultiplier);
    }
}