package com.github.tartaricacid.touhoulittlemaid.entity.data;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;

public class TaskDataRegister {
    private static final Map<class_2960, TaskDataKey<?>> MAPS = Maps.newHashMap();

    public static void init() {
        TaskDataRegister register = new TaskDataRegister();
        // 注册本模组自己的数据
        InitTaskData.registerAll(register);
        // 注册第三方模组添加的数据
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerTaskData(register);
        }
    }

    @SuppressWarnings("all")
    public static <T> TaskDataKey<T> getValue(class_2960 key) {
        return (TaskDataKey<T>) MAPS.get(key);
    }

    public <T> TaskDataKey<T> register(class_2960 key, Codec<T> codec) {
        return register(key, codec, codec);
    }

    public <T> TaskDataKey<T> register(class_2960 key, Codec<T> saveCodec, Codec<T> syncCodec) {
        TaskDataKey<T> value = new TaskDataKey<>() {
            @Override
            public class_2960 getKey() {
                return key;
            }

            @Override
            public class_2487 writeSaveData(T data) {
                return saveCodec.encodeStart(class_2509.field_11560, data)
                        .resultOrPartial(TouhouLittleMaid.LOGGER::error)
                        .map(tag -> (class_2487) tag)
                        .orElse(new class_2487());
            }

            @Override
            public T readSaveData(class_2487 compound) {
                return saveCodec.parse(class_2509.field_11560, compound)
                        .resultOrPartial(TouhouLittleMaid.LOGGER::error)
                        .orElse(null);
            }

            @Override
            public class_2487 writeSyncData(T data) {
                return syncCodec.encodeStart(class_2509.field_11560, data)
                        .resultOrPartial(TouhouLittleMaid.LOGGER::error)
                        .map(tag -> (class_2487) tag)
                        .orElse(new class_2487());
            }

            @Override
            public T readSyncData(class_2487 compound) {
                return syncCodec.parse(class_2509.field_11560, compound)
                        .resultOrPartial(TouhouLittleMaid.LOGGER::error)
                        .orElse(null);
            }
        };
        return register(value);
    }

    public <T> TaskDataKey<T> register(TaskDataKey<T> value) {
        MAPS.put(value.getKey(), value);
        return value;
    }
}
