package com.github.tartaricacid.touhoulittlemaid.entity.favorability;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidFavorabilityLevelChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

/**
 * FIXME：这个好感度机制太落伍了，未来需要重新设计一个更合理的好感度系统
 */
public class FavorabilityManager {
    public static final Map<String, Type> TYPES = Maps.newHashMap();

    private static final int LEVEL_0 = 0;
    private static final int LEVEL_1 = 1;
    private static final int LEVEL_2 = 2;
    private static final int LEVEL_3 = 3;

    private static final int LEVEL_0_POINT = 0;
    private static final int LEVEL_1_POINT = 64;
    private static final int LEVEL_2_POINT = 192;
    private static final int LEVEL_3_POINT = 384;

    private static final int LEVEL_0_HEALTH = 20;
    private static final int LEVEL_1_HEALTH = 30;
    private static final int LEVEL_2_HEALTH = 40;
    private static final int LEVEL_3_HEALTH = 80;

    private static final int LEVEL_0_ATTACK_DAMAGE = 2;
    private static final int LEVEL_1_ATTACK_DAMAGE = 3;
    private static final int LEVEL_2_ATTACK_DAMAGE = 4;
    private static final int LEVEL_3_ATTACK_DAMAGE = 6;

    private static final int LEVEL_0_ATTACK_DISTANCE_PLUS = 0;
    private static final int LEVEL_1_ATTACK_DISTANCE_PLUS = 1;
    private static final int LEVEL_2_ATTACK_DISTANCE_PLUS = 3;
    private static final int LEVEL_3_ATTACK_DISTANCE_PLUS = 5;

    private static final double LEVEL_0_SWEEP_RANGE = 1;
    private static final double LEVEL_1_SWEEP_RANGE = 2;
    private static final double LEVEL_2_SWEEP_RANGE = 3;
    private static final double LEVEL_3_SWEEP_RANGE = 4;

    private static final String TAG_NAME = "FavorabilityManagerCounter";

    private final Map<String, Time> counter;
    private final EntityMaid maid;

    public FavorabilityManager(EntityMaid maid) {
        this.counter = Maps.newHashMap();
        this.maid = maid;
    }

    public void tick() {
        counter.values().forEach(Time::tick);
    }

    public void apply(String type) {
        Type typeInstance = TYPES.get(type);
        if (typeInstance != null) {
            this.apply(typeInstance);
        }
    }

    public void apply(Type type) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(type.getPoint());
            } else {
                this.add(type.getPoint());
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    public void apply(Type type, int point) {
        if (this.canAdd(type.getTypeName())) {
            if (type.isReduce()) {
                this.reduce(point);
            } else {
                this.add(point);
            }
            this.addCooldown(type.getTypeName(), type.getCooldown());
        }
    }

    private void addCooldown(String type, int tickCount) {
        this.counter.put(type, new Time(tickCount));
    }

    public boolean canAdd(String type) {
        if (this.counter.containsKey(type)) {
            return this.counter.get(type).isZero();
        }
        return true;
    }

    public int getLevel() {
        return this.getLevel(maid.getFavorability());
    }

    private int getLevel(int favorability) {
        if (favorability < LEVEL_1_POINT) {
            return LEVEL_0;
        } else if (favorability < LEVEL_2_POINT) {
            return LEVEL_1;
        } else if (favorability < LEVEL_3_POINT) {
            return LEVEL_2;
        } else {
            return LEVEL_3;
        }
    }

    public double getLevelPercent() {
        int favorability = this.maid.getFavorability();
        if (favorability < LEVEL_1_POINT) {
            return favorability / (double) LEVEL_1_POINT;
        } else if (favorability < LEVEL_2_POINT) {
            return (favorability - LEVEL_1_POINT) / (double) (LEVEL_2_POINT - LEVEL_1_POINT);
        } else if (favorability < LEVEL_3_POINT) {
            return (favorability - LEVEL_2_POINT) / (double) (LEVEL_3_POINT - LEVEL_2_POINT);
        } else {
            return 0;
        }
    }

    public int nextLevelPoint() {
        int level = this.getLevel();
        if (level == LEVEL_3) {
            return 0;
        }
        int pointByLevel = getPointByLevel(level + 1);
        return pointByLevel - this.maid.getFavorability();
    }

    public int getHealthByLevel(int level) {
        switch (level) {
            case LEVEL_1 -> {
                return LEVEL_1_HEALTH;
            }
            case LEVEL_2 -> {
                return LEVEL_2_HEALTH;
            }
            case LEVEL_3 -> {
                return LEVEL_3_HEALTH;
            }
            default -> {
                return LEVEL_0_HEALTH;
            }
        }
    }

    public int getAttackByLevel(int level) {
        switch (level) {
            case LEVEL_1 -> {
                return LEVEL_1_ATTACK_DAMAGE;
            }
            case LEVEL_2 -> {
                return LEVEL_2_ATTACK_DAMAGE;
            }
            case LEVEL_3 -> {
                return LEVEL_3_ATTACK_DAMAGE;
            }
            default -> {
                return LEVEL_0_ATTACK_DAMAGE;
            }
        }
    }

    public int getAttackDistancePlusByPoint(int favorability) {
        if (favorability < LEVEL_1_POINT) {
            return LEVEL_0_ATTACK_DISTANCE_PLUS;
        } else if (favorability < LEVEL_2_POINT) {
            return LEVEL_1_ATTACK_DISTANCE_PLUS;
        } else if (favorability < LEVEL_3_POINT) {
            return LEVEL_2_ATTACK_DISTANCE_PLUS;
        } else {
            return LEVEL_3_ATTACK_DISTANCE_PLUS;
        }
    }

    public class_238 getSweepRange(class_1297 target, int favorability) {
        class_238 boundingBox = target.method_5829();
        if (favorability < LEVEL_1_POINT) {
            return sweepRangeTransform(boundingBox, LEVEL_0_SWEEP_RANGE);
        } else if (favorability < LEVEL_2_POINT) {
            return sweepRangeTransform(boundingBox, LEVEL_1_SWEEP_RANGE);
        } else if (favorability < LEVEL_3_POINT) {
            return sweepRangeTransform(boundingBox, LEVEL_2_SWEEP_RANGE);
        } else {
            return sweepRangeTransform(boundingBox, LEVEL_3_SWEEP_RANGE);
        }
    }

    private class_238 sweepRangeTransform(class_238 boundingBox, double range) {
        return boundingBox.method_1009(range, Math.max(range / 4, 0.25), range);
    }

    public int getPointByLevel(int level) {
        switch (level) {
            case LEVEL_1 -> {
                return LEVEL_1_POINT;
            }
            case LEVEL_2 -> {
                return LEVEL_2_POINT;
            }
            case LEVEL_3 -> {
                return LEVEL_3_POINT;
            }
            default -> {
                return LEVEL_0_POINT;
            }
        }
    }

    public void add(int addPoint) {
        int favorability = maid.getFavorability();
        int levelBefore = getLevel();
        int result = class_3532.method_15340(favorability + addPoint, 0, LEVEL_3_POINT);
        maid.setFavorability(result);
        int levelAfter = getLevel();

        if (levelBefore < levelAfter) {
            class_1324 attack = maid.method_5996(class_5134.field_23721);
            class_1324 health = maid.method_5996(class_5134.field_23716);

            if (attack != null) {
                attack.method_6192(this.getAttackByLevel(levelAfter));
            }

            if (health != null) {
                if (maid.isStruckByLightning()) {
                    health.method_6192(this.getHealthByLevel(levelAfter) + 20);
                } else {
                    health.method_6192(this.getHealthByLevel(levelAfter));
                }
                if (maid.method_6032() > maid.method_6063()) {
                    maid.method_6033(maid.method_6063());
                }
                if (maid.method_6063() >= 100 && maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.MAID_100_HEALTHY);
                }
            }

            if (maid.method_35057() instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.FAVORABILITY_INCREASED);
                if (levelAfter == LEVEL_3) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.FAVORABILITY_INCREASED_MAX);
                }
            }

            // 最后触发事件和饰品
            this.onFavorabilityLevelChange(levelBefore, levelAfter);
        }
        NetworkHandler.sendToNearby(maid, new SpawnParticlePackage(maid.method_5628(), SpawnParticlePackage.Type.HEART));
    }

    public void reduce(int reducePoint) {
        int favorability = maid.getFavorability();
        int pointByLevel = getPointByLevel(getLevel());
        int result = class_3532.method_15340(favorability - reducePoint, pointByLevel, LEVEL_3_POINT);
        maid.setFavorability(result);
    }

    public void reduceWithoutLevel(int reducePoint) {
        int favorability = maid.getFavorability();
        int levelBefore = getLevel();
        int result = class_3532.method_15340(favorability - reducePoint, 0, LEVEL_3_POINT);
        maid.setFavorability(result);
        int levelAfter = getLevel();

        if (levelBefore > levelAfter) {
            class_1324 attack = maid.method_5996(class_5134.field_23721);
            class_1324 health = maid.method_5996(class_5134.field_23716);

            if (attack != null) {
                attack.method_6192(this.getAttackByLevel(levelAfter));
            }

            if (health != null) {
                if (maid.isStruckByLightning()) {
                    health.method_6192(this.getHealthByLevel(levelAfter) + 20);
                } else {
                    health.method_6192(this.getHealthByLevel(levelAfter));
                }
                if (maid.method_6032() > maid.method_6063()) {
                    maid.method_6033(maid.method_6063());
                }
            }

            // 最后触发事件和饰品
            this.onFavorabilityLevelChange(levelBefore, levelAfter);
        }
    }

    public void onFavorabilityLevelChange(int oldLevel, int newLevel) {
        // 最后触发事件和饰品
        this.maid.getMaidBauble().fireEvent((b, s) -> {
            b.onFavorabilityLevelChange(this.maid, s, oldLevel, newLevel);
            return false;
        });
        MaidFavorabilityLevelChangeEvent.CALLBACK.invoker().post(new MaidFavorabilityLevelChangeEvent(maid, oldLevel, newLevel));
    }

    public void max() {
        this.add(LEVEL_3_POINT);
    }

    public void addAdditionalSaveData(class_2487 compound) {
        class_2487 data = new class_2487();
        this.counter.forEach((name, time) -> data.method_10569(name, time.getTickCount()));
        compound.method_10566(TAG_NAME, data);
    }

    public void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10573(TAG_NAME, class_2520.field_33260)) {
            class_2487 data = compound.method_10562(TAG_NAME);
            for (String name : data.method_10541()) {
                this.counter.put(name, new Time(data.method_10550(name)));
            }
        }
    }

    public static class Time {
        private int tickCount;

        public Time(int tickCount) {
            this.tickCount = tickCount;
        }

        public int getTickCount() {
            return tickCount;
        }

        public void setTickCount(int tickCount) {
            this.tickCount = tickCount;
        }

        public void tick() {
            if (tickCount > 0) {
                tickCount--;
            }
        }

        public boolean isZero() {
            return this.tickCount <= 0;
        }
    }
}