package com.github.tartaricacid.touhoulittlemaid.entity.item;

import cn.sh1rocu.touhoulittlemaid.util.forge.network.IEntityExtension;
import cn.sh1rocu.touhoulittlemaid.util.forge.network.IEntityWithComplexSpawn;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.BeaconAbsorbPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2775;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_5819;
import net.minecraft.class_9129;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment.POWER_NUM;

public class EntityPowerPoint extends class_1297 implements IEntityWithComplexSpawn, IEntityExtension {
    public static final class_1299<EntityPowerPoint> TYPE = class_1299.class_1300.<EntityPowerPoint>method_5903(EntityPowerPoint::new, class_1311.field_17715)
            .method_17687(0.5F, 0.5F).method_27299(6).method_27300(20).method_5905("power_point");
    private static final int MAX_AGE = 6000;
    public int field_6012;
    public int age;
    public int throwTime;
    public int value;
    private int health = 5;
    private class_1657 followingPlayer;
    private int followingTime;

    public EntityPowerPoint(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityPowerPoint(class_1937 worldIn, double x, double y, double z, int powerValue) {
        this(TYPE, worldIn);
        this.method_5814(x, y, z);
        this.method_36456((float) (this.field_5974.method_43058() * 360.0));
        this.method_18800((this.field_5974.method_43058() * 0.2 - 0.1) * 2.0,
                this.field_5974.method_43058() * 0.2 * 2.0,
                (this.field_5974.method_43058() * 0.2 - 0.1) * 2.0);
        this.value = powerValue;
    }

    public static int getPowerValue(int powerValue) {
        if (powerValue >= 485) {
            return 485;
        } else if (powerValue >= 385) {
            return 385;
        } else if (powerValue >= 285) {
            return 285;
        } else if (powerValue >= 185) {
            return 185;
        } else if (powerValue >= 89) {
            return 89;
        } else if (powerValue >= 36) {
            return 34;
        } else if (powerValue >= 17) {
            return 13;
        } else if (powerValue >= 7) {
            return 7;
        } else if (powerValue >= 5) {
            return 5;
        } else {
            return powerValue >= 3 ? 3 : 1;
        }
    }

    /**
     * P 点可以向经验转换，转换比率为 4P = 1 XP
     */
    public static int transPowerValueToXpValue(int powerValue) {
        return powerValue / 4;
    }

    public static void spawnExplosionParticle(class_1937 world, float x, float y, float z, class_5819 rand) {
        if (!world.field_9236) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            float mx = (rand.method_43057() - 0.5F) * 0.02F;
            float my = (rand.method_43057() - 0.5F) * 0.02F;
            float mz = (rand.method_43057() - 0.5F) * 0.02F;
            world.method_8406(class_2398.field_11204,
                    x + rand.method_43057() - 0.5F,
                    y + rand.method_43057() - 0.5F,
                    z + rand.method_43057() - 0.5F,
                    mx, my, mz);
        }
    }

    public void spawnExplosionParticle() {
        float x = (float) method_19538().field_1352;
        float y = (float) method_19538().field_1351 + 0.125F;
        float z = (float) method_19538().field_1350;
        if (field_6002.field_9236) {
            spawnExplosionParticle(field_6002, x, y, z, field_5974);
        } else {
            NetworkHandler.sendToNearby(this, new BeaconAbsorbPackage(x, y, z));
        }
    }

    @Override
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (this.throwTime > 0) {
            --this.throwTime;
        }

        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.fluidMovement();
        if (!this.field_6002.method_18026(this.method_5829())) {
            this.method_5632(this.method_23317(), (this.method_5829().field_1322 + this.method_5829().field_1325) / 2.0, this.method_23321());
        }
        this.followingMovement();
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.groundMovement();

        ++this.field_6012;
        ++this.age;
        if (this.age >= MAX_AGE) {
            this.method_31472();
        }
    }

    private void groundMovement() {
        double slipperiness = 0.98;
        if (this.method_24828()) {
            class_2338 pos = new class_2338((int) this.method_23317(), (int) (this.method_23318() - 1.0), (int) this.method_23321());
            //slipperiness = this.level.getBlockState(pos).getFriction(this.level, pos, this) * 0.98;
            slipperiness = this.field_6002.method_8320(pos).method_26204().method_9499() * 0.98;
        }
        this.method_18799(this.method_18798().method_18805(slipperiness, 0.98, slipperiness));
        if (this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(1.0, -0.9, 1.0));
        }
    }

    private void followingMovement() {
        double distance = 8.0;
        if (this.followingTime < getRandomCheckTime()) {
            if (this.followingPlayer == null || this.followingPlayer.method_5739(this) > distance) {
                this.followingPlayer = this.field_6002.method_18460(this, distance);
            }
            this.followingTime = this.field_6012;
        }

        if (this.followingPlayer != null && this.followingPlayer.method_7325()) {
            this.followingPlayer = null;
        }

        if (this.followingPlayer != null) {
            class_243 relativeVector = new class_243(this.followingPlayer.method_23317() - this.method_23317(),
                    this.followingPlayer.method_23318() + this.followingPlayer.method_5751() / 2.0 - this.method_23318(),
                    this.followingPlayer.method_23321() - this.method_23321());
            double length = relativeVector.method_1033();
            if (length < distance) {
                double factor = 1.0 - length / 8.0;
                this.method_18799(this.method_18798().method_1019(relativeVector.method_1029().method_1021(factor * factor * 0.1D)));
            }
        }
    }

    private int getRandomCheckTime() {
        return this.field_6012 - 20 + this.method_5628() % 100;
    }

    private void fluidMovement() {
        if (this.method_5777(class_3486.field_15517)) {
            class_243 movement = this.method_18798();
            this.method_18800(movement.field_1352 * 0.99, Math.min(movement.field_1351 + 0.0005, 0.06), movement.field_1350 * 0.99);
        } else if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
        }

        if (this.field_6002.method_8316(this.method_24515()).method_15767(class_3486.field_15518)) {
            this.method_18800((this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2,
                    0.2, (this.field_5974.method_43058() - this.field_5974.method_43058()) * 0.2);
            this.method_5783(class_3417.field_14821, 0.4F, 2.0F + this.field_5974.method_43057() * 0.4F);
        }
    }

    @Override
    protected void method_5746() {
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.field_6002.field_9236 || !this.method_5805()) {
            return false;
        }
        if (!this.method_5679(source)) {
            this.method_5785();
            this.health = (int) ((float) this.health - amount);
            if (this.health <= 0) {
                this.method_31472();
            }
        }
        return false;
    }

    @Override
    public void method_5652(class_2487 compound) {
        compound.method_10575("Health", (short) this.health);
        compound.method_10575("Age", (short) this.age);
        compound.method_10575("Value", (short) this.value);
    }

    @Override
    public void method_5749(class_2487 compound) {
        this.health = compound.method_10568("Health");
        this.age = compound.method_10568("Age");
        this.value = compound.method_10568("Value");
    }

    @Override
    public void method_5694(class_1657 player) {
        if (this.field_6002.field_9236) {
            return;
        }

        if (this.throwTime == 0 && player.field_7504 == 0) {
            PowerAttachment power = player.getAttachedOrCreate(POWER_NUM, () -> new PowerAttachment(0));
            MaidNumAttachment maidNum = player.getAttachedOrCreate(InitDataAttachment.MAID_NUM, () -> new MaidNumAttachment(0));
            player.field_7504 = 2;
            this.take(player, 1);
            if (this.value > 0) {
                if (power.get() + value / 100.0f > PowerAttachment.MAX_POWER) {
                    power.add(PowerAttachment.MAX_POWER - power.get());
                    int residualValue = value - (int) (PowerAttachment.MAX_POWER * 100) + (int) (power.get() * 100);
                    // 和原版设计不同，该数值过大，故缩小一些
                    player.method_7255(transPowerValueToXpValue(residualValue));
                    player.setAttached(POWER_NUM, new PowerAttachment(power.get()));
                } else {
                    power.add(value / 100.0f);
                    player.setAttached(POWER_NUM, new PowerAttachment(power.get()));
                }
            }
            ServerPlayNetworking.send((class_3222) player, new SyncDataPackage(power.get(), maidNum.get()));
            this.method_31472();
            if (player instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.PICKUP_POWER_POINT);
            }
        }
    }

    public void take(class_1297 player, int quantity) {
        if (this.method_5805() && !this.field_6002.field_9236) {
            ((class_3218) this.field_6002).method_14178().method_18754(this, new class_2775(this.method_5628(), player.method_5628(), quantity));
        }
    }

    public int getValue() {
        return this.value;
    }

    @Environment(EnvType.CLIENT)
    public int getIcon() {
        if (this.value >= 485) {
            return 10;
        } else if (this.value >= 385) {
            return 9;
        } else if (this.value >= 285) {
            return 8;
        } else if (this.value >= 185) {
            return 7;
        } else if (this.value >= 89) {
            return 6;
        } else if (this.value >= 36) {
            return 5;
        } else if (this.value >= 17) {
            return 4;
        } else if (this.value >= 7) {
            return 3;
        } else if (this.value >= 5) {
            return 2;
        } else {
            return this.value >= 3 ? 1 : 0;
        }
    }

    @Override
    public boolean method_5732() {
        return false;
    }

    @Override
    public void writeSpawnData(class_9129 buffer) {
        buffer.method_53002(value);
    }

    @Override
    public void readSpawnData(class_9129 additionalData) {
        this.value = additionalData.readInt();
    }
}
