package com.github.tartaricacid.touhoulittlemaid.entity.misc;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_9139;

public enum MonsterType implements class_3542 {
    FRIENDLY,
    NEUTRAL,
    HOSTILE;

    public static final Codec<MonsterType> CODEC = class_3542.method_28140(MonsterType::values);
    public static final class_9139<ByteBuf, MonsterType> STREAM_CODEC = class_9139.method_56437(
            (byteBuf, type) -> byteBuf.writeInt(type.ordinal()),
            byteBuf -> getTypeByIndex(byteBuf.readInt())
    );

    private final class_5250 component;

    MonsterType() {
        this.component = class_2561.method_43471("gui.touhou_little_maid.monster_type." + this.name().toLowerCase(Locale.ENGLISH));
    }

    public static MonsterType getTypeByIndex(int index) {
        int length = MonsterType.values().length;
        return MonsterType.values()[Math.min(index, length - 1)];
    }

    public MonsterType getPrevious() {
        int index = this.ordinal() - 1;
        if (index < 0) {
            index = values().length - 1;
        }
        return values()[index % values().length];
    }

    public MonsterType getNext() {
        int ordinal = this.ordinal();
        int length = MonsterType.values().length;
        return MonsterType.values()[(ordinal + 1) % length];
    }

    public class_5250 getComponent() {
        return component;
    }

    @Override
    public String method_15434() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}