package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2945;

import static com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid.GAME_SKILL;
import static com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid.GAME_STATUE;

public class MaidGameRecordManager {
    private static final String GAME_SKILL_TAG = "MaidGameSkillData";
    private static final String GOMOKU = "Gomoku";
    private static final byte NONE = 0, WIN = 1, LOSE = 2;

    private final EntityMaid maid;

    public MaidGameRecordManager(EntityMaid maid) {
        this.maid = maid;
    }

    void defineSynchedData(class_2945.class_9222 builder) {
        builder.method_56912(GAME_SKILL, new class_2487());
        builder.method_56912(GAME_STATUE, (byte) 0);
    }

    void addAdditionalSaveData(class_2487 compound) {
        compound.method_10566(GAME_SKILL_TAG, getGameSkill());
    }

    void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10573(GAME_SKILL_TAG, class_2520.field_33260)) {
            setGameSkill(compound.method_10562(GAME_SKILL_TAG));
        }
    }

    void tick() {
        if (!(this.maid.method_5854() instanceof EntitySit) && getGameStatue() != NONE) {
            resetStatue();
        }
    }

    private class_2487 getGameSkill() {
        return maid.method_5841().method_12789(GAME_SKILL);
    }

    private void setGameSkill(class_2487 gameSkill) {
        maid.method_5841().method_49743(GAME_SKILL, gameSkill, true);
    }

    private byte getGameStatue() {
        return maid.method_5841().method_12789(GAME_STATUE);
    }

    private void setGameStatue(byte gameStatue) {
        maid.method_5841().method_12778(GAME_STATUE, gameStatue);
    }

    public int getGomokuWinCount() {
        class_2487 gameSkill = this.getGameSkill();
        if (gameSkill.method_10573(GOMOKU, class_2520.field_33253)) {
            return gameSkill.method_10550(GOMOKU);
        }
        return 0;
    }

    public void increaseGomokuWinCount() {
        class_2487 gameSkill = this.getGameSkill();
        if (gameSkill.method_10573(GOMOKU, class_2520.field_33253)) {
            gameSkill.method_10569(GOMOKU, gameSkill.method_10550(GOMOKU) + 1);
        } else {
            gameSkill.method_10569(GOMOKU, 1);
        }
        this.setGameSkill(gameSkill);
    }

    public boolean isWin() {
        return this.getGameStatue() == WIN;
    }

    public boolean isLost() {
        return this.getGameStatue() == LOSE;
    }

    public void markStatue(boolean isWin) {
        this.setGameStatue(isWin ? WIN : LOSE);
        if (isWin) {
            maid.method_5783(InitSounds.GAME_WIN, 1, 1);
        } else {
            maid.method_5783(InitSounds.GAME_LOST, 1, 1);
        }
    }

    public void resetStatue() {
        this.setGameStatue(NONE);
    }
}
